package com.bringspring.system.external.controller.mutil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.util.JSSDKUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * 企业微信 JS-SDK 公共
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2023-06-20
 */
@Slf4j
@RestController
@RequestMapping("/api/cp/jssdk")
public class JSSDKController {

    @Autowired
    WxCpConfiguration wxCpConfiguration;

    /**
     * 获取 配置微信config信息
     *
     * @param url    （当前网页的URL，不包含#及其后面部分）
     * @param corpId 企业微信corpId
     * @return
     */
    @GetMapping("/getWxconfig")
    public ActionResult list(String url, String corpId) {
        if (StringUtils.isEmpty(url)) {
            return ActionResult.fail("参数herfUrl不能为空.");
        }
        if (StringUtils.isEmpty(corpId)) {
            return ActionResult.fail("参数corpId不能为空.");
        }
        try {
            //  url前端base64加密后端解密
            url = URLDecoder.decode(url, "utf-8");
            //  corpId前端base64加密后端解密
            corpId = URLDecoder.decode(corpId, "utf-8");
            WeComModel weComModel = wxCpConfiguration.getWeComModel(corpId);
            if (ObjectUtil.isEmpty(weComModel)) {
                return ActionResult.fail(String.format("未找到对应corpId=[%s]的配置，请核实！", corpId));
            }
            // 初始化企业微信设置
            JSSDKUtil.setCorpId(weComModel.getQyhCorpId());
            JSSDKUtil.setCorpSecret(weComModel.getQyhAgentSecret());
            // 获取signature及其他参数信息
            JSONObject signAndOtherData = JSSDKUtil.getSignAndOtherData(url);
            return ActionResult.success("获取成功", signAndOtherData);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ActionResult.fail("base64参数解码失败");
        }
    }

}
