package com.bringspring.system.msgcenter.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.msgcenter.entity.McMsgSendEntity;
import com.bringspring.system.msgcenter.entity.McMsgSendTemplateEntity;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendCrForm;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendPagination;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendUpForm;

import java.util.List;

/**
 * 消息发送配置表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-12
 */
public interface McMsgSendService extends IService<McMsgSendEntity> {

    List<McMsgSendEntity> getList(McMsgSendPagination mcMsgSendPagination);

    List<McMsgSendEntity> getListAll(McMsgSendPagination mcMsgSendPagination);

    List<McMsgSendEntity> getTypeList(McMsgSendPagination mcMsgSendPagination, String dataType);


    McMsgSendEntity getInfo(String id);

    McMsgSendEntity getEntityByEnCode(String enCode);

    McMsgSendInfoVO getInfoByEnCode(String enCode);

    McMsgSendEntity getValidInfo(String enCode);

    void delete(McMsgSendEntity entity);

    void create(McMsgSendCrForm mcMsgSendCrForm);

    boolean update(String id, McMsgSendUpForm mcMsgSendUpForm);

    //  子表方法
    List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String id);

    //  子表方法
    List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String id, Integer enabledMark);

    //  子表方法
    List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String sendId, String templateId, Integer enabledMark);

    /**
     * 校验编码code的唯一
     *
     * @return 结果
     */
    boolean checkEnCodeUnique(String enCode, String id);
    /**
     * 校验名称的唯一
     *
     * @return 结果
     */
    boolean checkFullNameUnique(String fullName, String id);

    /**
     * 根据消息场景来源 统计发送配置数量
     * @param messageSource
     * @return
     */
    long getCountByMessageSource(String messageSource);
}
