package com.bringspring.system.msgcenter.service.strategy.impl;

import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.msgcenter.constant.Constants.ReadStatus;
import com.bringspring.system.msgcenter.entity.*;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * WEBHOOK策略
 * 特殊注意：接收者从应用授权webhook配置信息,mc_msg_account获取。
 */
@Component
public class WebhookStrategy extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WEBHOOK;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg,
                               McMsgSendTemplateModel sendTemplate,
                               Map<String, McTaskMsgContentEntity> contentMap,
                               Map<String, List<McTaskMsgReceiveEntity>> receiveMap,
                               Set<String> userSet) {
        String taskMsgId = taskMsg.getId();

        String templateId = sendTemplate.getId(); // 发送配置消息模板
        String channelType = sendTemplate.getMessageType(); // 消息渠道
        String msgTemplateId = sendTemplate.getTemplateId(); // 消息模板
        String msgAccountId = sendTemplate.getAccountConfigId(); // 授权应用配置

        // 授权应用
        McMsgAccountEntity account = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        // 消息模板
        McMsgTemplateEntity msgTemplate = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());


        String webhookKey = channelType + msgTemplateId + msgAccountId;
        // 消息内容
        McTaskMsgContentEntity webhookContent;
        if (!contentMap.containsKey(webhookKey)) {
            webhookContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(webhookKey, webhookContent); // 渠道模板应用消息内容
        } else {
            webhookContent = contentMap.get(webhookKey);
        }

        // 消息接收人：发送配置渠道消息模板关联应用账号sendTemplate.getAccountConfigId()
        // 使用 computeIfAbsent 自动处理键存在性检查及初始化
        receiveMap.computeIfAbsent(webhookKey, k -> {
            // 接收者: 应用授权webhook配置信息,mc_msg_account获取。
            McTaskMsgReceiveEntity webhookReceiveEntity = new McTaskMsgReceiveEntity();
            webhookReceiveEntity.setId(RandomUtil.uuId());
            webhookReceiveEntity.setMsgId(taskMsgId);
            // 发送配置模板id
            webhookReceiveEntity.setTemplateId(templateId);
            webhookReceiveEntity.setMsgTemplateId(msgTemplateId);
            webhookReceiveEntity.setMsgAccountId(msgAccountId);
            webhookReceiveEntity.setContentId(webhookContent.getId());
            // webhook
            webhookReceiveEntity.setChannelType(channelType);
            // 下发渠道接收者：发送配置渠道消息模板关联应用账号sendTemplate.getAccountConfigId()
            webhookReceiveEntity.setReceiveUserId(sendTemplate.getAccountConfigId());
            // 冗余字段 接收人系统用户表无账号，设为空
            webhookReceiveEntity.setSysUserId(null);
            // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
            webhookReceiveEntity.setEnabledMark(0);
            // 是否阅读，0否、1是
            webhookReceiveEntity.setIsRead(ReadStatus.UNREAD.getCode());
            webhookReceiveEntity.setDescription(null);
            return new ArrayList<>(Arrays.asList(webhookReceiveEntity));
        });
    }

}