package com.bringspring.system.msgcenter.util;

import com.bringspring.system.msgcenter.model.MySmsModel;

import java.util.List;
import java.util.Map;

/**
 * 短信工具类
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-12-11
 */
public class SmsSentUtil {

    // 私有构造函数，防止类被实例化
    private SmsSentUtil() {
        throw new UnsupportedOperationException("工具类不允许实例化");
    }

    /**
     * 获取短信模板参数
     *
     * @param type
     * @param smsModel
     * @param templateId
     * @return
     */
    public static List<String> querySmsTemplateRequest(Integer type, MySmsModel smsModel, String endpoint, String region, String templateId) {
        if (type == 1) {
            return SmsAliYunSentUtil.querySmsTemplateRequest(smsModel.getAliAccessKey(), smsModel.getAliSecret(),
                    endpoint, templateId);
        }
        return SmsTenCentCloudSentUtil.querySmsTemplateRequest(smsModel.getTencentSecretId(), smsModel.getTencentSecretKey(), endpoint , region, templateId);
    }

    /**
     * 获取短信模板内容
     *
     * @param type
     * @param smsModel
     * @param templateId
     * @return
     */
    public static String querySmsTemplateContent(Integer type, MySmsModel smsModel, String endpoint, String region, String templateId) {
        if (type == 1) {
            return SmsAliYunSentUtil.querySmsTemplateContent(smsModel.getAliAccessKey(), smsModel.getAliSecret(), endpoint, templateId);
        }
        return SmsTenCentCloudSentUtil.querySmsTemplateContent(smsModel.getTencentSecretId(), smsModel.getTencentSecretKey(), endpoint , region, templateId);
    }

    /**
     * 发送消息
     *
     * @param type
     * @param smsModel
     * @param phoneNumbers
     * @param signContent
     * @param templateId
     * @param map
     * @return
     */
    public static String sentSms(Integer type, MySmsModel smsModel, String endpoint, String region, String phoneNumbers, String signContent, String templateId, Map<String, Object> map) {
        if (type == 1) {
            return SmsAliYunSentUtil.sentSms(smsModel.getAliAccessKey(), smsModel.getAliSecret(), endpoint, phoneNumbers, signContent, templateId, map);
        }
        return SmsTenCentCloudSentUtil.sentSms(smsModel.getTencentSecretId(), smsModel.getTencentSecretKey(), endpoint, region, phoneNumbers, smsModel.getTencentAppId(), signContent, templateId, map);
    }

}
