package com.bringspring.system.permission.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 *
 * 机构分级管理员
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("BASE_ORGANIZE_ADMINISTRATOR")
public class OrganizeAdministratorEntity {

    @TableId("ID")
    private String id;

    @TableField("USER_ID")
    private String userId;

    @TableField("ORGANIZE_ID")
    private String organizeId;

    @TableField("ORGANIZE_TYPE")
    private String organizeType;

    @TableField("THIS_LAYER_ADD")
    private Integer thisLayerAdd;

    @TableField("THIS_LAYER_EDIT")
    private Integer thisLayerEdit;

    @TableField("THIS_LAYER_DELETE")
    private Integer thisLayerDelete;

    /**
     * 本层查看
     */
    @TableField("THIS_LAYER_SELECT")
    private Integer thisLayerSelect;

    @TableField("SUBLAYER_ADD")
    private Integer subLayerAdd;

    @TableField("SUBLAYER_EDIT")
    private Integer subLayerEdit;

    @TableField("SUBLAYER_DELETE")
    private Integer subLayerDelete;

    /**
     * 子层查看
     */
    @TableField("SUB_LAYER_SELECT")
    private Integer subLayerSelect;

    @TableField("DESCRIPTION")
    private String description;

    @TableField("SORT_CODE")
    private Long sortCode;

    @TableField(value = "ENABLED_MARK",fill = FieldFill.INSERT)
    private Integer enabledMark;

    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    @TableField("DELETE_MARK")
    private Integer deleteMark;

    @TableField("DELETE_TIME")
    private Date deleteTime;

    @TableField("DELETE_USER_ID")
    private String deleteUserId;


}
