package com.bringspring.system.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.Pagination;
import com.bringspring.system.permission.entity.GroupEntity;

import java.util.List;
import java.util.Set;

/**
 * 用户管理业务层
 *
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/10 17:59
 */
public interface GroupService extends IService<GroupEntity> {

    /**
     * 获取用户列表
     *
     * @param pagination 关键字
     * @return
     */
    List<GroupEntity> getList(Pagination pagination);

    /**
     * 获取所有格分组信息
     *
     * @return
     */
    List<GroupEntity> list();

    /**
     * 通过关键字查询
     *
     * @return
     */
    List<GroupEntity> list(String keyword);

    /**
     * 获取用户详情
     *
     * @param id
     * @return
     */
    GroupEntity getInfo(String id);

    /**
     * 添加
     *
     * @param entity
     */
    void crete(GroupEntity entity);

    /**
     * 修改
     *
     * @param id
     * @param entity
     */
    Boolean update(String id, GroupEntity entity);

    /**
     * 删除
     *
     * @param entity
     */
    void delete(GroupEntity entity);

    /**
     * 判断名称是否重复
     *
     * @param fullName
     * @param id
     * @return
     */
    Boolean isExistByFullName(String fullName, String id);

    /**
     * 判断编码是否重复
     *
     * @param enCode
     * @param id
     * @return
     */
    Boolean isExistByEnCode(String enCode, String id);

    /**
     * 分组列表
     *
     * @param idList
     * @return
     */
    List<GroupEntity> getGroupList(List<String> idList);


    /**
     * 分组列表
     *
     * @param idList
     * @return
     */
    List<GroupEntity> getGroupList(Set<String> idList);

    /**
     * 分组列表
     *
     * @return
     */
    List<GroupEntity> getListByIds(List<String> ids);
}
