package com.bringspring.system.permission.service.strategy;

import com.bringspring.common.util.StringUtils;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import com.bringspring.system.permission.service.OrganizeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * This class is used to search for users who are subordinates of the current user.
 */
@Component
public class ContentStringOrganizationAndSuborganization extends FieldContentStringStrategy {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;

    public ContentStringOrganizationAndSuborganization() {
        super();
        this.order = 20;
        this.conditionOptions = new ArrayList<>();
        conditionOptions.add(new HashMap<String, Object>() {{
            put("value", AuthorizeConditionEnum.ORGANIZEANDUNDER.getCondition());
            put("label", AuthorizeConditionEnum.ORGANIZEANDUNDER.getMessage());
        }});
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsBatch();
    }

    @Override
    public Object convertFieldContent(String fieldContent, String symbol) {
        List<String> underOrganizations = new ArrayList<>();
        String orgId = userProvider.get().getOrganizeId();
        if (StringUtils.isNotEmpty(userProvider.get().getDepartmentId())) {
            orgId = userProvider.get().getDepartmentId();
        }
        underOrganizations.add(orgId);
        underOrganizations.addAll(organizeService.getUnderOrganizations(orgId));
        return underOrganizations;
    }
}
