package com.bringspring.system.permission.service.strategy;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * This class is used to search for users who are subordinates of the current user.
 */
@Component
public class ContentStringUserAraSubordinates extends FieldContentStringStrategy {

    @Autowired
    private UserProvider userProvider;

    public ContentStringUserAraSubordinates() {
        super();
        this.order = 10;
        this.conditionOptions = new ArrayList<>();
        conditionOptions.add(new HashMap<String, Object>() {{
            put("value", AuthorizeConditionEnum.USERANDUNDER.getCondition());
            put("label", AuthorizeConditionEnum.USERANDUNDER.getMessage());
        }});
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsBatch();
    }

    @Override
    public Object convertFieldContent(String fieldContent, String symbol) {
        List<String> idsList = new ArrayList<>();
        if (userProvider.get().getSubordinateIds().size() > 0) {
            idsList = userProvider.get().getSubordinateIds();
        }
        idsList.add(userProvider.get().getUserId());
        return idsList;
    }
}
