package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.DataInterfaceLogEntity;
import com.bringspring.system.base.model.dataInterface.DataInterfaceLogVO;
import com.bringspring.system.base.service.DataInterfaceLogService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 数据接口调用日志控制器
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-06-03
 */
@Tag(name = "数据接口调用日志")
@RestController
@RequestMapping("/api/system/DataInterfaceLog")
public class DataInterfaceLogController {
    @Autowired
    private DataInterfaceLogService dataInterfaceLogService;
    @Autowired
    private UserService userService;

    /**
     * 获取数据接口调用日志列表
     *
     * @param id         主键
     * @param pagination 分页参数
     * @return ignore
     */
    @Operation(summary="获取数据接口调用日志列表")
    @GetMapping("{id}")
    public ActionResult getList(@PathVariable("id") String id, Pagination pagination) {
        List<DataInterfaceLogEntity> list = dataInterfaceLogService.getList(id, pagination);
        List<DataInterfaceLogVO> voList = JsonUtil.getJsonToList(list, DataInterfaceLogVO.class);
        for (DataInterfaceLogVO vo : voList) {
            UserEntity entity = userService.getInfo(vo.getUserId());
            if (entity != null) {
                vo.setUserId(entity.getRealName() );
            }
        }
        PaginationVO vo = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        return ActionResult.page(voList, vo);
    }
}
