package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.*;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.entity.ModuleFormEntity;
import com.bringspring.system.base.model.form.*;
import com.bringspring.system.base.model.module.PropertyJsonModel;
import com.bringspring.system.base.service.ModuleFormService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 表单权限
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2021-09-14
 */
@Tag(name = "表单权限")
@RestController
@RequestMapping("/api/system/ModuleForm")
public class ModuleFormController {

    @Autowired
    private ModuleFormService moduleFormService;
    @Autowired
    private ModuleService moduleService;

    /**
     * 获取表单权限列表
     *
     * @param moduleId   功能主键
     * @param pagination 分页参数
     * @return ignore
     */
    @Operation(summary="获取表单权限列表")
    @GetMapping("/{moduleId}/Fields")
    public ActionResult getList(@PathVariable("moduleId") String moduleId, Pagination pagination) {
        List<ModuleFormEntity> list = moduleFormService.getList(moduleId, pagination);
        List<ModuleFormListVO> voList = JsonUtil.getJsonToList(list, ModuleFormListVO.class);
        voList.stream().forEach(t-> {
            if (StringUtils.isNotEmpty(t.getEnCode())) {
                t.setEnCode(StringUtils.isNotEmpty(t.getEnCode()) ? t.getEnCode().replace("jsbos_" + t.getBindTable() + "_jsbos_", "") : "");
            }
        });
        ListVO vo = new ListVO<>();
        vo.setList(voList);
        return ActionResult.success(vo);
    }

    /**
     * 菜单数据权限
     *
     * @param moduleId 功能主键
     * @return ignore
     */
    @Operation(summary="菜单数据权限")
    @GetMapping("/{moduleId}/FieldList")
    public ActionResult fieldList(@PathVariable("moduleId") String moduleId) {
        List<Map<String, String>> list = new ArrayList<>();
        // 得到菜单id
        ModuleEntity entity = moduleService.getInfo(moduleId);
        PropertyJsonModel model = JsonUtil.getJsonToBean(entity.getPropertyJson(), PropertyJsonModel.class);
        if (model == null) {
            model = new PropertyJsonModel();
        }
        // 得到bean
        Object bean = SpringContext.getBean("visualdevServiceImpl");
        Object method = ReflectionUtil.invokeMethod(bean, "getInfo", new Class[]{String.class}, new Object[]{model.getModuleId()});
        Map<String, Object> map = JsonUtil.entityToMap(method);
        if (map != null && map.containsKey("formData")) {
            FormDataModel formDataModel = JsonUtil.getJsonToBean(String.valueOf(map.get("formData")), FormDataModel.class);
            List<FieLdsModel> fieLdsModelList = JsonUtil.getJsonToList(formDataModel.getFields(), FieLdsModel.class);
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setList(fieLdsModelList);
            recursionForm.setTableModelList(JsonUtil.getJsonToList(String.valueOf(map.get("tables")), TableModel.class));
            List<FormAllModel> formAllModel = new ArrayList<>();
            FormCloumnUtil.recursionForm(recursionForm, formAllModel);
            for (FormAllModel allModel : formAllModel) {
                if (FormEnum.table.getMessage().equals(allModel.getKeyName())) {
                    FormColumnTableModel childList = allModel.getChildList();
                    Map<String, String> map1 = new HashedMap<>();
                    map1.put("field", childList.getTableModel());
                    map1.put("fieldName", childList.getLabel());
                    list.add(map1);
                } else if (FormEnum.mast.getMessage().equals(allModel.getKeyName())) {
                    FormColumnModel formColumnModel = allModel.getFormColumnModel();
                    FieLdsModel fieLdsModel = formColumnModel.getFieLdsModel();
                    if (StringUtils.isNotEmpty(fieLdsModel.getVModel())) {
                        Map<String, String> map1 = new HashedMap<>();
                        map1.put("field", fieLdsModel.getVModel());
                        map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                        list.add(map1);
                    }
                } else if (FormEnum.mastTable.getMessage().equals(allModel.getKeyName())) {
                    FormMastTableModel formColumnModel = allModel.getFormMastTableModel();
                    FieLdsModel fieLdsModel = formColumnModel.getMastTable().getFieLdsModel();
                    if (StringUtils.isNotEmpty(fieLdsModel.getVModel())) {
                        Map<String, String> map1 = new HashedMap<>();
                        map1.put("field", fieLdsModel.getVModel());
                        map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                        list.add(map1);
                    }
                }
            }
        }
        return ActionResult.success(list);
    }

    /**
     * 获取表单权限信息
     *
     * @param id 主键值
     * @return ignore
     * @throws DataException ignore
     */
    @Operation(summary="获取表单权限信息")
    @GetMapping("/{id}")
    public ActionResult<ModuleFormInfoVO> info(@PathVariable("id") String id) throws DataException {
        ModuleFormEntity entity = moduleFormService.getInfo(id);
        ModuleEntity moduleEntity = moduleService.getInfo(entity.getModuleId());
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty(entity.getBindTable())) {
            entity.setEnCode(entity.getEnCode().replace("jsbos_" + entity.getBindTable() + "_jsbos_", ""));
        }
        ModuleFormInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, ModuleFormInfoVO.class);
        return ActionResult.success(vo);
    }

    /**
     * 新建表单权限
     *
     * @param moduleFormCrForm 实体对象
     * @return ignore
     */
    @Operation(summary="新建表单权限")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ModuleFormCrForm moduleFormCrForm) {
        ModuleEntity moduleEntity = moduleService.getInfo(moduleFormCrForm.getModuleId());
        ModuleFormEntity entity = JsonUtil.getJsonToBean(moduleFormCrForm, ModuleFormEntity.class);
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty(entity.getBindTable())) {
            String enCode = "jsbos_" + entity.getBindTable() + "_jsbos_" + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        if (moduleFormService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), entity.getId())) {
            return ActionResult.fail("字段名称不能重复");
        }
        moduleFormService.create(entity);
        return ActionResult.success(MsgCode.SU001.get());
    }

    /**
     * 更新表单权限
     *
     * @param id               主键值
     * @param moduleFormUpForm 实体对象
     * @return ignore
     */
    @Operation(summary="更新表单权限")
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid ModuleFormUpForm moduleFormUpForm) {
        ModuleEntity moduleEntity = moduleService.getInfo(moduleFormUpForm.getModuleId());
        ModuleFormEntity entity = JsonUtil.getJsonToBean(moduleFormUpForm, ModuleFormEntity.class);
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty(entity.getBindTable())) {
            String enCode = "jsbos_" + entity.getBindTable() + "_jsbos_" + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        if (moduleFormService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), id)) {
            return ActionResult.fail("字段名称不能重复");
        }
        boolean flag = moduleFormService.update(id, entity);
        if (!flag) {
            return ActionResult.success(MsgCode.FA002.get());
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

    /**
     * 删除表单权限
     *
     * @param id 主键值
     * @return
     */
    @Operation(summary="删除表单权限")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        ModuleFormEntity entity = moduleFormService.getInfo(id);
        if (entity != null) {
            moduleFormService.delete(entity);
            return ActionResult.success(MsgCode.SU003.get());
        }
        return ActionResult.fail(MsgCode.FA003.get());
    }

    /**
     * 批量新建
     */
    @Operation(summary="批量新建表单权限")
    @PostMapping("/Actions/Batch")
    public ActionResult batchCreate(@RequestBody @Valid FormBatchForm formBatchForm) {
        List<ModuleFormEntity> entitys = formBatchForm.getFormJson() != null ? JsonUtil.getJsonToList(formBatchForm.getFormJson(), ModuleFormEntity.class) : new ArrayList<>();
        List<String> name = new ArrayList<>();
        for (ModuleFormEntity entity : entitys) {
            entity.setModuleId(formBatchForm.getModuleId());
            if (moduleFormService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), null)) {
                return ActionResult.fail(MsgCode.EXIST002.get());
            }
            if (name.contains(entity.getEnCode())) {
                return ActionResult.fail(MsgCode.EXIST002.get());
            }
            name.add(entity.getEnCode());
        }
        moduleFormService.create(entitys);
        return ActionResult.success(MsgCode.SU001.get());
    }

    /**
     * 更新表单权限状态
     *
     * @param id 主键值
     * @return
     */
    @Operation(summary="更新表单权限状态")
    @PutMapping("/{id}/Actions/State")
    public ActionResult upState(@PathVariable("id") String id) {
        ModuleFormEntity entity = moduleFormService.getInfo(id);
        entity.setEnabledMark("1".equals(String.valueOf(entity.getEnabledMark())) ? 0 : 1);
        boolean flag = moduleFormService.update(id, entity);
        if (!flag) {
            return ActionResult.success(MsgCode.FA002.get());
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

}
