package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 系统版本管理
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-01-13
 */
@Data
@TableName("BASE_VERSION")
public class BaseVersionEntity {
    /** 主键 **/
    @TableId("ID")
    private String id;

    /** 标题 **/
    @TableField("TITLE")
    private String title;

    /** 版本 **/
    @TableField("VERSION")
    private String version;

    /** 更新内容 **/
    @TableField("CONTENT")
    private String content;

    /** 发送时间 **/
    @TableField("SEND_TIME")
    private Date sendTime;

    /** 发送人 **/
    @TableField("SEND_USER_ID")
    private String sendUserId;

    /** 发送类型 1 全员 2 指定范围 3 不发送 **/
    @TableField("SEND_TYPE")
    private String sendType;
    /** 是否发送 0 未发送 1 已发送 **/
    @TableField("IS_SEND")
    private String isSend;

    /** 发送范围 **/
    @TableField("SEND_RANGE")
    private String sendRange;

    /** 描述 **/
    @TableField("DESCRIPTION")
    private String description;

    /** 状态 0 暂存 1发布 **/
    @TableField("ENABLED_MARK")
    private String enabledMark;

    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.UPDATE)
    private Date lastModifyTime;

}
