package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 数据权限配置
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_MODULE_DATA_AUTHORIZE")
public class ModuleDataAuthorizeEntity {
    /**
     * 数据主键
     */
    @TableId("ID")
    private String id;

    /**
     * 菜单主键
     */
    @TableField("MODULE_ID")
    private String moduleId;

    /**
     * 字段名称
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 绑定表格Id
     */
    @TableField("BIND_TABLE")
    private String bindTable;

    /**
     * 字段规则（0-主表规则 1-副表规则 2-子表规则）
     * 副表规则：与主表是一对一的主从关系。
     * 子表规则：与主表是一对多的主从关系。
     */
    @TableField("FIELD_RULE")
    private Integer fieldRule;

    /**
     * 子表规则key （fieldRule=2时填写）
     * 输入表单设计内设计子表的控件字段名，例：tableField107
     */
    @TableField("CHILD_TABLE_KEY")
    private String childTableKey;

    /**
     * 字段说明
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 字段类型
     * string；int；double；varchar；datetime；text；bigint。
     */
    @TableField("TYPE")
    private String type;

    /**
     * 条件内容 (根据type不同，选填内容不同)
     */
    @TableField("CONDITION_TEXT")
    private String conditionText;

    /**
     * 时间类型(conditionText=datePicker时必填)
     */
    @TableField("DATE_FORMAT")
    private String dateFormat;

    /**
     * 条件符号(根据type和conditionText不同，选填内容不同)
     */
    @TableField("CONDITION_SYMBOL")
    private String conditionSymbol;

    /**
     * 条件符号Json
     */
    @TableField("CONDITION_SYMBOL_JSON")
    private String conditionSymbolJson;

    /**
     * 扩展属性
     */
    @TableField("PROPERTY_JSON")
    private String propertyJson;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
