package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 短息模板表
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021年12月8日17:40:37
 */
@TableName(value ="BASE_SMS_TEMPLATE")
@Data
public class SmsTemplateEntity implements Serializable {
    /**
     * 自然主键
     */
    @TableId(value = "ID")
    private String id;

    /**
     * 短信提供商
     */
    @TableField(value = "COMPANY")
    private Integer company;

    /**
     * 应用编号
     */
    @TableField(value = "APP_ID")
    private String appId;

    /**
     * 签名内容
     */
    @TableField(value = "SIGN_CONTENT")
    private String signContent;

    /**
     * 模板编号
     */
    @TableField(value = "TEMPLATE_ID")
    private String templateId;

    /**
     * 模板名称
     */
    @TableField(value = "FULL_NAME")
    private String fullName;

    /**
     * 模板参数JSON
     */
    @TableField(value = "TEMPLATE_JSON")
    private String templateJson;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField("LAST_MODIFY_TIME")
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    /**
     * 编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * endpoint
     */
    @TableField("ENDPOINT")
    private String endpoint;

    /**
     * 地域参数
     */
    @TableField("REGION")
    private String region;
}
