package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.systemconfig.QyChatModel;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.system.base.entity.EmailConfigEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;

import java.util.List;
import java.util.Map;

/**
 * 系统配置
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface SysConfigService extends IService<SysConfigEntity> {

    /**
     * 列表
     *
     * @return ignore
     */
    List<SysConfigEntity> getList();

    /**
     * 获取系统配置
     *
     * @return
     */
    public BaseSystemInfo getSysInfo();

    /**
     * 获取企业微信配置信息
     *
     * @return
     */
    public QyChatModel getQyChatInfo() throws BaseException;

    /**
     * 根据分类获取配置
     *
     * @param category
     * @return
     * @throws BaseException
     */
    public Map<String, String> getConfigsByCategory(String category) throws BaseException;

    /**
     * 获取系统地址
     *
     * @param terminal 终端：app:手机端，pc:电脑端
     * @return
     * @throws BaseException
     */
    public String getSystemAddress(String terminal) throws BaseException;

    /**
     * 根据配置KeyName查找配置
     *
     * @param keyName
     * @return
     * @throws BaseException
     */
    public SysConfigEntity getConfigByKeyName(String keyName) throws BaseException;

    /**
     * 获取企业微信实例配置，过滤敏感信息
     *
     * @return
     * @throws BaseException
     */
    List<QyChatModel> getQyChatModelList() throws BaseException;

    /**
     * 保存系统配置
     *
     * @param entitys  实体对象
     * @param category 配置分类
     */
    void saveBatch(List<SysConfigEntity> entitys, String category) throws BaseException;

    /**
     * @param sysConfigEntity
     */
    void create(SysConfigEntity sysConfigEntity);

    /**
     * 根据分组删除配置
     *
     * @param category
     */
    public void deleteByCategory(String category);

    /**
     * 按照KeyName删配置
     *
     * @param keyName
     */
    public void deleteByKeyName(String keyName);

    /**
     * 邮箱验证
     *
     * @param configEntity ignore
     * @return ignore
     */
    String checkMainLogin(EmailConfigEntity configEntity);

    List<SysConfigEntity> getConfigListByCategory(String category) throws BaseException;
}
