package com.bringspring.system.base.util.jobutil;

import cn.hutool.core.bean.BeanUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.model.ContentModel;
import com.bringspring.system.scheduletask.service.TimeService;
import lombok.extern.slf4j.Slf4j;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

import java.util.Map;


/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Slf4j
public class TimeJob implements Job {

    @Override
    public void execute(JobExecutionContext context) {
        JobDataMap dataMap = context.getMergedJobDataMap();
        ContentModel model = dataMap.get("content") != null ? (ContentModel) dataMap.get("content") : null;
        String type = dataMap.getString("type");
        String id = dataMap.getString("id");
        String tenantId = dataMap.getString("tenantId");
        String token = dataMap.getString("token");
        TimeTaskEntity timeTaskEntity = (TimeTaskEntity) dataMap.get("timeTaskEntity");
        Map<String, Object> stringObjectMap = BeanUtil.beanToMap(timeTaskEntity);
        String tenantDbConnectionString = dataMap.getString("tenantDbConnectionString");
        if (model != null) {
            if (StringUtils.isNotEmpty(tenantId)) {
                DataSourceContextHolder.setDatasource(tenantId, tenantDbConnectionString);
            }
            TimeService timeService = SpringContext.getBean(TimeService.class);
            if ("1".equals(type)) {
                timeService.connector(model, id, token, tenantId, tenantDbConnectionString);
            } else if ("3".equals(type)) {
                timeService.localTask(model, id, token, tenantId, tenantDbConnectionString, stringObjectMap);
            } else {
                timeService.storage(model, id, tenantId, tenantDbConnectionString, token);
            }
        }
    }

}
