package com.bringspring.system.external.config.single;

import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;

@Slf4j
//@Configuration
//@EnableConfigurationProperties(WxMpProperties.class)
public class WxMpConfiguration {

    private final WxMpProperties properties;

    @Autowired
    public WxMpConfiguration(WxMpProperties properties) {
        this.properties = properties;
    }


    @Bean
    public WxMpService wxMpService() {
        if (properties == null) {
            throw new WxRuntimeException("未添加下相关配置！");
        }
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        config.setAppId(properties.getAppid()); // 设置微信公众号的appid
        config.setSecret(properties.getSecret()); // 设置微信公众号的app corpSecret
        config.setToken(properties.getToken()); // 设置微信公众号的token
        config.setAesKey(properties.getAesKey()); // 设置微信公众号的EncodingAESKey

        WxMpService wxService = new WxMpServiceImpl();
        wxService.setWxMpConfigStorage(config);
        return wxService;
    }
}
