package com.bringspring.system.external.controller.mutil;

import com.bringspring.common.base.ActionResult;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.service.impl.MyWxCpLinkedCorpServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpAgentPerm;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpDepartment;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequiredArgsConstructor
@RequestMapping("/wx/cp/{corpId}/{agentId}")
@Slf4j
public class WxCpController {

    @Autowired
    WxCpConfiguration wxCpConfiguration;

    @PostMapping("/getLinkedCorp")
    public ActionResult getLinkedCorp(
            @PathVariable("corpId") String corpId,
            @PathVariable("agentId") Integer agentId) throws WxErrorException {

        final WxCpService wxCpService = wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            return ActionResult.fail(String.format("未找到对应corpId=[%s]、agentId=[%d]的配置，请核实！", corpId, agentId));
        }

        MyWxCpLinkedCorpServiceImpl wxCpLinkedCorpService = new MyWxCpLinkedCorpServiceImpl();
        wxCpLinkedCorpService.setWxCpService(wxCpService);
        WxCpLinkedCorpAgentPerm linkedCorpAgentPerm =
                wxCpLinkedCorpService.getLinkedCorpAgentPerm();
        List<WxCpLinkedCorpDepartment> linkedCorpDepartmentList =
                wxCpLinkedCorpService.getLinkedCorpDepartmentList("wh87896fbeb5dcdd15/1");
        List<MyWxCpLinkedCorpUser> linkedCorpUserList =
                wxCpLinkedCorpService.getLinkedCorpUserList("wh87896fbeb5dcdd15/334");
        MyWxCpLinkedCorpUser wxCpLinkedCorpUser =
                wxCpLinkedCorpService.getLinkedCorpUser("wx04efb4c9c3f81554/10118");
        List<WxCpLinkedCorpUser> linkedCorpSimpleUserList =
                wxCpLinkedCorpService.getLinkedCorpSimpleUserList("wh87896fbeb5dcdd15/471");

        Map res = new HashMap<String, String>();
        res.put("appId", corpId);
        res.put("agentId", agentId);
        res.put("linkedCorpAgentPerm", linkedCorpAgentPerm);
        res.put("linkedCorpDepartmentList", linkedCorpDepartmentList);
        res.put("linkedCorpUserList", linkedCorpUserList);
        res.put("wxCpLinkedCorpUser", wxCpLinkedCorpUser);
        res.put("linkedCorpSimpleUserList", linkedCorpSimpleUserList);
        return ActionResult.success(res);
    }

    @PostMapping("/getCorp")
    public ActionResult getCorp(
            @PathVariable("corpId") String corpId,
            @PathVariable("agentId") Integer agentId) throws WxErrorException {

        final WxCpService wxCpService = wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            return ActionResult.fail(String.format("未找到对应corpId=[%s]、agentId=[%d]的配置，请核实！", corpId, agentId));
        }


        Long id = null;
        // 获取部门列表
        List<WxCpDepart> departList = wxCpService.getDepartmentService().list(id);
        // 获取子部门ID列表
        List<WxCpDepart> wxCpDeparts = wxCpService.getDepartmentService().simpleList(id);
        // 获取单个部门详情
        WxCpDepart wxCpDepart = wxCpService.getDepartmentService().get(1L);

        // 读取成员
        WxCpUser user = wxCpService.getUserService().getById("18666299269");
        // 获取部门成员
        List<WxCpUser> wxCpUsers = wxCpService.getUserService().listSimpleByDepartment(1L, true, 0);
        // 获取部门成员详情
        // departId - 必填。部门id
        // fetchChild - 非必填。1/0：是否递归获取子部门下面的成员
        // status - 非必填。0获取全部员工，1获取已关注成员列表，2获取禁用成员列表，4获取未关注成员列表。status可叠加
        List<WxCpUser> users = wxCpService.getUserService().listByDepartment(1L, true, 0);
        // 获取成员ID列表
//        WxCpDeptUserResult userListId = wxCpService.getUserService().getUserListId(null, null);

        Map res = new HashMap<String, String>();
        res.put("departList", departList);
        res.put("wxCpDeparts", wxCpDeparts);
        res.put("wxCpDepart", wxCpDepart);
        res.put("user", user);
        res.put("wxCpUsers", wxCpUsers);
        res.put("users", users);
//        res.put("userListId", userListId);
        return ActionResult.success(res);
    }

    public static String genNonce() {
        return bytesToHex(Long.toString(System.nanoTime()).getBytes(StandardCharsets.UTF_8));
    }

    public static String bytesToHex(final byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

}
