package com.bringspring.system.message.service;

import com.bringspring.system.base.exception.WxErrorException;
import com.bringspring.system.permission.entity.OrganizeEntity;

/**
 * 本系统的公司、部门、用户与企业微信的同步
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/27 11:12
 */
public interface SynThirdQyService {

    /**
     * 获取企业微信的配置信息
     *
     * @return
     */
//    BaseSystemInfo getQyhConfig();

    //------------------------------------本系统同步公司、部门到企业微信-------------------------------------

    /**
     * 本地同步单个公司或部门到企业微信(供调用)
     *
     * @param isBatch     是否批量(批量不受开关限制)
     * @param deptEntity
     * @param accessToken (单条调用时为空)
     * @return
     * @throws WxErrorException
     */
//    JSONObject createDepartmentSysToQy(boolean isBatch, OrganizeEntity deptEntity, String accessToken) throws WxErrorException;

    /**
     * 本地更新单个公司或部门到企业微信(供调用)
     *
     * @param isBatch     是否批量(批量不受开关限制)
     * @param deptEntity
     * @param accessToken (单条调用时为空)
     * @return
     * @throws WxErrorException
     */
//    JSONObject updateDepartmentSysToQy(boolean isBatch, OrganizeEntity deptEntity, String accessToken,BaseSystemInfo config) throws Exception;

    /**
     * 本地删除单个公司或部门，同步到企业微信(供调用)
     *
     * @param isBatch     是否批量(批量不受开关限制)
     * @param id          本系统的公司或部门ID
     * @param accessToken (单条调用时为空)
     * @return
     * @throws WxErrorException
     */
//    JSONObject deleteDepartmentSysToQy(boolean isBatch, String id, String accessToken) throws WxErrorException;


    //------------------------------------本系统同步用户到企业微信-------------------------------------

    /**
     * 本地用户创建同步到企业微信的成员(单个)
     *
     * @param isBatch     是否批量(批量不受开关限制)
     * @param userEntity
     * @param accessToken (单条调用时为空)
     * @return
     * @throws WxErrorException
     */
//    JSONObject createUserSysToQy(boolean isBatch, UserEntity userEntity, String accessToken) throws WxErrorException;

    /**
     * 本地更新用户信息或部门到企业微信的成员信息(单个)
     *
     * @param isBatch     是否批量(批量不受开关限制)
     * @param userEntity
     * @param accessToken (单条调用时为空)
     * @return
     * @throws WxErrorException
     */
//    JSONObject updateUserSysToQy(boolean isBatch, UserEntity userEntity, String accessToken) throws WxErrorException;

    /**
     * 本地删除单个用户，同步到企业微信成员
     *
     * @param isBatch     是否批量(批量不受开关限制)
     * @param id          本系统的公司或部门ID
     * @param accessToken (单条调用时为空)
     * @return
     * @throws WxErrorException
     */
//    JSONObject deleteUserSysToQy(boolean isBatch, String id, String accessToken) throws WxErrorException;

    /**
     * 创建组织
     *
     * @param entity 实体对象
     */
    void createOrgan(OrganizeEntity entity);


    /**
     * 将组织、用户的信息写入同步表
     *
     * @param opType             "add":创建 “upd”:修改
     * @param synThirdInfoEntity 本地同步表信息
     * @param thirdType          第三方类型
     * @param dataType           数据类型
     * @param sysObjId           本地对象ID
     * @param thirdObjId         第三方对象ID
     * @param synState           同步状态(0:未同步;1:同步成功;2:同步失败)
     * @param description
     */
//    public void saveSynThirdInfoEntity(String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, Integer synState, String description);


//    QyWebChatUserModel getQyUserById(String id, String accessToken) throws WxErrorException;

//    void synQyToOrganizeSys(String id, String companyId) throws Exception;

//    void synQyToUserSys(String id, String companyId) throws Exception;
}
