package com.bringspring.system.msgcenter.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;


/**
 * 业务场景消息接收记录表
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Data
@TableName("MC_TASK_MSG_RECEIVE")
public class McTaskMsgReceiveEntity {

    @TableId("ID")
    private String id;

    @TableField("MSG_ID")
    private String msgId;

    @TableField("TEMPLATE_ID")
    private String templateId;

    @TableField("MSG_TEMPLATE_ID")
    private String msgTemplateId;

    @TableField("MSG_ACCOUNT_ID")
    private String msgAccountId;

    @TableField("CONTENT_ID")
    private String contentId;

    @TableField("CHANNEL_TYPE")
    private String channelType;

    @TableField("SYS_USER_ID")
    private String sysUserId;

    @TableField("RECEIVE_USER_ID")
    private String receiveUserId;

    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    @TableField("SEND_TIME")
    private Date sendTime;

    @TableField("SEND_USER_ID")
    private String sendUserId;

    @TableField("AGAIN_TIME")
    private Date againTime;

    @TableField("AGAIN_USER_ID")
    private String againUserId;

    @TableField("AUTO_AGAIN_NUM")
    private Integer autoAgainNum;

    @TableField("AUTO_AGAIN_MAX_NUM")
    private Integer autoAgainMaxNum;

    @TableField("IS_READ")
    private Integer isRead;

    @TableField("READ_TIME")
    private Date readTime;

    @TableField("READ_COUNT")
    private Integer readCount;

    @TableField("DESCRIPTION")
    private String description;

    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    @TableField("DELETE_TIME")
    private Date deleteTime;

    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    @TableField("DELETE_MARK")
    private Integer deleteMark;

}
