package com.bringspring.system.msgcenter.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.exception.MsgCenterException;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgCrForm;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgPagination;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgUpForm;
import me.chanjar.weixin.common.error.WxErrorException;

import java.util.List;
import java.util.Map;

/**
 * 业务场景消息表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-14
 */
public interface McTaskMsgService extends IService<McTaskMsgEntity> {

    List<McTaskMsgEntity> getList(McTaskMsgPagination mcTaskMsgPagination);

    List<McTaskMsgEntity> getTypeList(McTaskMsgPagination mcTaskMsgPagination, String dataType);


    McTaskMsgEntity getInfo(String id);

    void delete(McTaskMsgEntity entity);

    void create(McTaskMsgCrForm mcTaskMsgCrForm);

    boolean update(String id, McTaskMsgUpForm mcTaskMsgUpForm);

    /**
     * 业务消息创建并下发
     * @param mcTaskMsgCrForm
     */
    void addAndSendMessage(McTaskMsgCrForm mcTaskMsgCrForm) throws Exception;

    /**
     * 业务消息创建
     * @param mcTaskMsgCrForm
     */
    McTaskMsgEntity addTaskMsg(McTaskMsgCrForm mcTaskMsgCrForm) throws MsgCenterException;

    /**
     * 业务消息下发
     *
     * @param entity 业务消息
     * @return
     */
    void sendTaskMsgReceive(McTaskMsgEntity entity) throws WxErrorException;

    /**
     * 按状态分类统计
     *
     * @return 结果
     */
    List<Map<String, Object>> selectGroupByEnabledMark(McTaskMsgPagination pagination);
}
