package com.bringspring.system.permission.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.*;
import com.bringspring.system.base.service.*;
import com.bringspring.system.permission.entity.*;
import com.bringspring.system.permission.model.authorize.*;
import com.bringspring.system.permission.model.columnspurview.ColumnsPurviewUpForm;
import com.bringspring.system.permission.service.*;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 操作权限
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Tag(name = "操作权限", description = "Authorize")
@RestController
@RequestMapping("/api/permission/Authority")
public class AuthorizeController {

    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ModuleButtonService buttonService;
    @Autowired
    private ModuleColumnService columnService;
    @Autowired
    private ModuleFormService formService;
    @Autowired
    private ModuleDataAuthorizeSchemeService schemeService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private ColumnsPurviewService columnsPurviewService;

    /**
     * 权限数据
     *
     * @param objectId 对象主键
     * @return
     */
    @Operation(summary = "获取权限数据")
    @GetMapping("/{objectId}")
    public ActionResult<AuthorizeDataVO> data(@PathVariable("objectId") String objectId) {

        List<ModuleEntity> moduleList = moduleService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        List<ModuleButtonEntity> moduleButtonList = buttonService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        List<ModuleColumnEntity> moduleColumnList = columnService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        List<ModuleFormEntity> moduleFormList = formService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        List<ModuleDataAuthorizeSchemeEntity> moduleDataSchemeList = schemeService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        AuthorizeVO authorizeModel = authorizeService.getAuthorize(true);
        List<AuthorizeEntity> authorizeList =
                authorizeService.list(new QueryWrapper<AuthorizeEntity>().lambda().eq(AuthorizeEntity::getObjectId,
                        objectId));


        AuthorizeDataVO vo = new AuthorizeDataVO();
        vo.setModule(authorizeService.module(moduleList, authorizeList, authorizeModel));
        vo.setButton(authorizeService.moduleButton(moduleList, moduleButtonList, authorizeList, authorizeModel));
        vo.setColumn(authorizeService.moduleColumn(moduleList, moduleColumnList, authorizeList, authorizeModel));
        vo.setForm(authorizeService.moduleForm(moduleList, moduleFormList, authorizeList, authorizeModel));
        vo.setResource(authorizeService.resourceData(moduleList, moduleDataSchemeList, authorizeList, authorizeModel));
        return ActionResult.success(vo);
    }


    /**
     * 权限数据
     *
     * @param objectId 对象主键
     * @return
     */
    @Operation(summary = "获取岗位/角色/用户权限树形结构")
    @GetMapping("/Data/{objectId}")
    public ActionResult<AuthorizeDataVO> getData(@PathVariable("objectId") String objectId) {

        List<ModuleEntity> moduleList = moduleService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        List<ModuleButtonEntity> moduleButtonList = buttonService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        List<ModuleColumnEntity> moduleColumnList = columnService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        List<ModuleFormEntity> moduleFormList = formService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        List<ModuleDataAuthorizeSchemeEntity> moduleDataSchemeList = schemeService.getList().stream().filter(
                m -> "1".equals(String.valueOf(m.getEnabledMark()))
        ).collect(Collectors.toList());

        AuthorizeVO authorizeModel = authorizeService.getAuthorize(true);
        List<AuthorizeEntity> list =
                authorizeService.list(new QueryWrapper<AuthorizeEntity>().lambda().eq(AuthorizeEntity::getObjectId,
                        objectId));


        AuthorizeDataVO vo = new AuthorizeDataVO();
        vo.setModule(authorizeService.module(moduleList, list, authorizeModel));
        vo.setButton(authorizeService.moduleButton(moduleList, moduleButtonList, list, authorizeModel));
        vo.setColumn(authorizeService.moduleColumn(moduleList, moduleColumnList, list, authorizeModel));
        vo.setForm(authorizeService.moduleForm(moduleList, moduleFormList, list, authorizeModel));
        vo.setResource(authorizeService.resourceData(moduleList, moduleDataSchemeList, list, authorizeModel));
        return ActionResult.success(vo);
    }


    /**
     * 权限数据
     *
     * @param objectId 对象主键
     * @return
     */
    @Operation(summary = "获取岗位/角色/用户权限树形结构")
    @PostMapping("/Data/{objectId}/Values")
    public ActionResult<AuthorizeDataReturnVO> getValuesData(@PathVariable("objectId") String objectId,
                                                             @RequestBody DataValuesQuery dataValuesQuery) {

        AuthorizeVO authorizeModel = authorizeService.getAuthorize(true);

        List<AuthorizeEntity> list =
                authorizeService.list(new QueryWrapper<AuthorizeEntity>().lambda().eq(AuthorizeEntity::getObjectId,
                        objectId));

        if (!StringUtils.isEmpty(dataValuesQuery.getType())) {
            AuthorizeDataReturnVO authorizeDataReturnVO = authorizeService.getAuthorizeDataReturnVO(authorizeModel,
                    list, dataValuesQuery, objectId);
            return ActionResult.success(authorizeDataReturnVO);
        }
        return ActionResult.fail("类型不能为空");
    }

    /**
     * 根据角色id权限数据
     *
     * @param objectId 对象主键
     * @return
     */
    @Operation(summary = "根据角色id获取岗位/角色/用户权限树形结构")
    @PostMapping("/RoleData/{objectId}/Values")
    public ActionResult<AuthorizeDataReturnVO> getRoleValuesData(@PathVariable("objectId") String objectId,
                                                                 @RequestBody DataValuesQuery dataValuesQuery) throws Exception {

        AuthorizeVO authorizeModel = authorizeService.getAuthorizeByRoleId(objectId);
        List<AuthorizeEntity> list =
                authorizeService.list(new QueryWrapper<AuthorizeEntity>().lambda().eq(AuthorizeEntity::getObjectId,
                        objectId));
        if (!StringUtils.isEmpty(dataValuesQuery.getType())) {
            AuthorizeDataReturnVO authorizeDataReturnVO = authorizeService.getAuthorizeDataReturnVO(authorizeModel,
                    list, dataValuesQuery, objectId);
            return ActionResult.success(authorizeDataReturnVO);
        }
        return ActionResult.fail("类型不能为空");
    }


    /**
     * 对象数据
     *
     * @return
     */
    @Operation(summary = "获取对象权限数据")
    @GetMapping("/DataObject")
    public ActionResult dataObject() {
        List<RoleEntity> roleData =
                roleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<OrganizeEntity> organizeData =
                organizeService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<PositionEntity> positionData =
                positionService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<UserEntity> userData =
                userService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        Map<String, Object> map = new HashMap<>(16);
        map.put("role", this.roleTree(roleData));
        map.put("position", this.positionTree(organizeData, positionData));
        map.put("user", this.userTree(organizeData, userData));
        return ActionResult.success(map);
    }


    /**
     * 对象数据
     *
     * @return
     */
    @Operation(summary = "获取功能权限数据")
    @GetMapping("/Model/{itemId}/{objectType}")
    public ActionResult getObjectAuth(@PathVariable("itemId") String itemId,
                                      @PathVariable("objectType") String objectType) {
        List<AuthorizeEntity> authorizeList = authorizeService.getListByObjectAndItem(itemId, objectType);
        List<String> ids = authorizeList.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        AuthorizeItemObjIdsVO vo = new AuthorizeItemObjIdsVO();
        vo.setIds(ids);
        return ActionResult.success(vo);
    }

    /**
     * 设置/更新功能权限
     *
     * @param itemId 对象主键
     * @return
     */
    @Operation(summary = "设置/更新功能权限")
    @PutMapping("/Model/{itemId}")
    @HandleLog(moduleName = "权限管理", requestMethod = "设置/更新功能权限")
    public ActionResult save(@PathVariable("itemId") String itemId, @RequestBody SaveAuthForm saveAuthForm) {
        authorizeService.saveAuth(itemId, saveAuthForm);
        return ActionResult.success(MsgCode.SU005.get());
    }


    /**
     * 保存
     *
     * @param objectId 对象主键
     * @return
     */
    @Operation(summary = "保存权限")
    @PutMapping("/Data/{objectId}")
    @HandleLog(moduleName = "权限管理", requestMethod = "保存权限")
    public ActionResult save(@PathVariable("objectId") String objectId,
                             @RequestBody AuthorizeDataUpForm authorizeDataUpForm) {
        authorizeService.save(objectId, authorizeDataUpForm);
        return ActionResult.success(MsgCode.SU005.get());
    }

    /**
     * 保存批量
     *
     * @return
     */
    @Operation(summary = "批量保存权限")
    @PostMapping("/Data/Batch")
    @HandleLog(moduleName = "权限管理", requestMethod = "批量保存权限")
    public ActionResult saveBatch(@RequestBody SaveBatchForm saveBatchForm) {
        // TODO 全局角色权限
        authorizeService.saveBatch(saveBatchForm, true);
        return ActionResult.success(MsgCode.SU005.get());
    }

    /**
     * 获取模块列表展示字段
     *
     * @param moduleId 菜单Id
     * @return
     */
    @Operation(summary = "获取模块列表展示字段")
    @GetMapping("/GetColumnsByModuleId/{moduleId}")
    public ActionResult getColumnsByModuleId(@PathVariable("moduleId") String moduleId) {
        ColumnsPurviewEntity entity = columnsPurviewService.getInfo(moduleId);
        List<Map<String, Object>> jsonToListMap = null;
        if (entity != null) {
            jsonToListMap = JsonUtil.getJsonToListMap(entity.getFieldList());
        }
        return ActionResult.success(jsonToListMap != null ? jsonToListMap : new ArrayList<>(16));
    }

    /**
     * 配置模块列表展示字段
     *
     * @param columnsPurviewUpForm 修改模型
     * @return
     */
    @Operation(summary = "配置模块列表展示字段")
    @PutMapping("/SetColumnsByModuleId")
    public ActionResult setColumnsByModuleId(@RequestBody ColumnsPurviewUpForm columnsPurviewUpForm) {
        ColumnsPurviewEntity entity = JsonUtil.getJsonToBean(columnsPurviewUpForm, ColumnsPurviewEntity.class);
        columnsPurviewService.update(columnsPurviewUpForm.getModuleId(), entity);
        return ActionResult.success(MsgCode.SU005.get());
    }


    /**
     * 角色信息
     *
     * @param data 数据
     * @return
     */
    AuthorizeDataReturnVO roleTree(List<RoleEntity> data) {
        List<AuthorizeDataModel> treeList = new ArrayList<>();
        List<DictionaryDataEntity> typeData = dictionaryDataService.getList("4501f6f26a384757bce12d4c4b03342c");
        for (DictionaryDataEntity entity : typeData) {
            AuthorizeDataModel dictionary = new AuthorizeDataModel();
            dictionary.setId(entity.getEnCode());
            dictionary.setFullName(entity.getFullName());
            dictionary.setShowcheck(false);
            dictionary.setParentId("-1");
            treeList.add(dictionary);
        }
        for (RoleEntity entity : data) {
            AuthorizeDataModel role = new AuthorizeDataModel();
            role.setId(entity.getId());
            role.setFullName(entity.getFullName());
            role.setParentId(entity.getType());
            role.setShowcheck(true);
            role.setIcon("fa fa-umbrella");
            treeList.add(role);
        }
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setList(JsonUtil.getJsonToList(TreeDotUtils.convertListToTreeDot(treeList), AuthorizeDataReturnModel.class));
        return vo;
    }

    /**
     * 岗位信息
     *
     * @param organizeData 机构
     * @param positionData 岗位
     * @return
     */
    AuthorizeDataReturnVO positionTree(List<OrganizeEntity> organizeData, List<PositionEntity> positionData) {
        List<AuthorizeDataModel> treeList = new ArrayList<>();
        for (OrganizeEntity entity : organizeData) {
            AuthorizeDataModel organize = new AuthorizeDataModel();
            organize.setId(entity.getId());
            organize.setShowcheck(false);
            organize.setFullName(entity.getFullName());
            organize.setParentId(entity.getParentId());
            treeList.add(organize);
        }
        for (PositionEntity entity : positionData) {
            AuthorizeDataModel position = new AuthorizeDataModel();
            position.setId(entity.getId());
            position.setFullName(entity.getFullName());
            position.setTitle(entity.getEnCode());
            position.setParentId(entity.getOrganizeId());
            position.setShowcheck(true);
            position.setIcon("fa fa-briefcase");
            treeList.add(position);
        }
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setList(JsonUtil.getJsonToList(TreeDotUtils.convertListToTreeDot(treeList), AuthorizeDataReturnModel.class));
        return vo;
    }

    /**
     * 用户信息
     *
     * @param organizeData 机构
     * @param userData     用户
     * @return
     */
    private AuthorizeDataReturnVO userTree(List<OrganizeEntity> organizeData, List<UserEntity> userData) {
        List<AuthorizeDataModel> treeList = new ArrayList<>();
        for (OrganizeEntity entity : organizeData) {
            AuthorizeDataModel organize = new AuthorizeDataModel();
            organize.setId(entity.getId());
            organize.setShowcheck(false);
            organize.setFullName(entity.getFullName());
            organize.setParentId(entity.getParentId());
            treeList.add(organize);
        }
        for (UserEntity entity : userData) {
            AuthorizeDataModel user = new AuthorizeDataModel();
            user.setId(entity.getId());
            user.setFullName(entity.getRealName());
            user.setParentId(entity.getOrganizeId());
            user.setShowcheck(true);
            user.setIcon("fa fa-user");
            treeList.add(user);
        }
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setList(JsonUtil.getJsonToList(TreeDotUtils.convertListToTreeDot(treeList), AuthorizeDataReturnModel.class));
        return vo;
    }

    /**
     * 获取表单条件内容、条件符号选项
     *
     * @return
     */
    @Operation(summary = "获取表单条件内容、条件符号选项")
    @GetMapping("/getDataAuthorizeFormSelect")
    public ActionResult getDataAuthorizeFormSelect() {
        Map<String, List<Map<String, Object>>> dataAuthorizeForm = authorizeService.getDataAuthorizeForm();
        return ActionResult.success(dataAuthorizeForm);
    }
}
