package com.bringspring.system.permission.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 模块列表权限
 *
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/15 9:20
 */
@Data
@TableName(value = "BASE_COLUMNS_PURVIEW")
public class ColumnsPurviewEntity {
    /**
     * 主键
     */
    @TableId("ID")
    private String id;
    /**
     * 列表字段数组
     */
    @TableField("FIELD_LIST")
    private String fieldList;
    /**
     * 模块ID
     */
    @TableField("MODULE_ID")
    private String moduleId;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;
}
