package com.bringspring.system.scheduletask.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 定时任务
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_TIMETASK")
public class TimeTaskEntity {
    /**
     * 定时任务主键
     */
    @TableId("ID")
    private String id;

    /**
     * 任务编码
     */
    @TableField("ENCODE")
    private String enCode;
    /**
     * 任务分组
     */
    @TableField("group_name")
    private String groupName;

    /**
     * 任务名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 执行类型 1.接口 2.存储过程 3.本地方法
     */
    @TableField("EXECUTE_TYPE")
    private String executeType;

    /**
     * 执行内容
     */
    @TableField("EXECUTE_CONTENT")
    private String executeContent;

    /**
     * 执行周期
     */
    @TableField("EXECUTE_CRON_EXPRESSION")
    private String executeCronExpression;

    /**
     * 最后运行时间
     */
    @TableField("LAST_RUN_TIME")
    private Date lastRunTime;

    /**
     * 下次运行时间
     */
    @TableField("NEXT_RUN_TIME")
    private Date nextRunTime;

    /**
     * 运行次数
     */
    @TableField("RUN_COUNT")
    private Integer runCount;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.INSERT_UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.INSERT_UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
