/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.BaseVersionEntity;
import com.bringspring.system.base.enums.BaseVersionSendMarkEnum;
import com.bringspring.system.base.model.baseversion.BaseVersionCrForm;
import com.bringspring.system.base.model.baseversion.BaseVersionInfoVO;
import com.bringspring.system.base.model.baseversion.BaseVersionListVO;
import com.bringspring.system.base.model.baseversion.BaseVersionPagination;
import com.bringspring.system.base.model.baseversion.BaseVersionUpForm;
import com.bringspring.system.base.service.BaseVersionService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.RangeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u7cfb\u7edf\u7248\u672c\u7ba1\u7406")
@RequestMapping(value={"/api/logistics/BaseVersion"})
public class BaseVersionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseVersionController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseVersionService baseVersionService;
    @Autowired
    private RangeService rangeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BaseVersionPagination baseVersionPagination) throws IOException {
        List<BaseVersionEntity> list = this.baseVersionService.getList(baseVersionPagination);
        List listVO = JsonUtil.getJsonToList(list, BaseVersionListVO.class);
        for (BaseVersionListVO vo : listVO) {
            if ("2".equals(vo.getSendType())) {
                List<UserEntity> rangeUserList = this.rangeService.getRangeUserList(vo.getSendRange());
                String userNames = rangeUserList.stream().map(UserEntity::getRealName).collect(Collectors.joining(","));
                vo.setSendRangUsers(userNames);
            }
            vo.setIsSend(BaseVersionSendMarkEnum.getDescByCode(vo.getIsSend()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)baseVersionPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid BaseVersionCrForm baseVersionCrForm) throws DataException {
        this.baseVersionService.create(baseVersionCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/release/{id}"})
    public ActionResult release(@PathVariable(value="id") String id) {
        return this.baseVersionService.release(id);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BaseVersionInfoVO> info(@PathVariable(value="id") String id) {
        BaseVersionEntity entity = this.baseVersionService.getInfo(id);
        BaseVersionInfoVO vo = (BaseVersionInfoVO)JsonUtil.getJsonToBean((Object)entity, BaseVersionInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BaseVersionInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BaseVersionEntity entity = this.baseVersionService.getInfo(id);
        BaseVersionInfoVO vo = (BaseVersionInfoVO)JsonUtil.getJsonToBean((Object)entity, BaseVersionInfoVO.class);
        if ("2".equals(vo.getSendType())) {
            List<UserEntity> rangeUserList = this.rangeService.getRangeUserList(vo.getSendRange());
            String userNames = rangeUserList.stream().map(UserEntity::getRealName).collect(Collectors.joining(","));
            vo.setSendRangUsers(userNames);
        }
        vo.setIsSend(BaseVersionSendMarkEnum.getDescByCode(vo.getIsSend()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/info"})
    public ActionResult<BaseVersionEntity> info() {
        BaseVersionEntity version = this.baseVersionService.getVersion();
        return ActionResult.success((Object)version);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BaseVersionUpForm baseVersionUpForm) throws DataException {
        this.baseVersionService.update(id, baseVersionUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        BaseVersionEntity entity = this.baseVersionService.getInfo(id);
        if (entity != null) {
            this.baseVersionService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

