/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.ModuleButtonEntity;
import com.bringspring.system.base.model.button.ButtonListVO;
import com.bringspring.system.base.model.button.ButtonTreeListModel;
import com.bringspring.system.base.model.button.ButtonTreeListVO;
import com.bringspring.system.base.model.button.ModuleButtonCrForm;
import com.bringspring.system.base.model.button.ModuleButtonInfoVO;
import com.bringspring.system.base.model.button.ModuleButtonUpForm;
import com.bringspring.system.base.service.ModuleButtonService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6309\u94ae\u6743\u9650")
@RestController
@RequestMapping(value={"/api/system/ModuleButton"})
public class ModuleButtonController {
    @Autowired
    private ModuleButtonService moduleButtonService;

    @Operation(summary="\u83b7\u53d6\u6309\u94ae\u6743\u9650\u5217\u8868")
    @GetMapping(value={"/{menuId}/List"})
    public ActionResult list(@PathVariable(value="menuId") String menuId, Pagination pagination) {
        List<ModuleButtonEntity> data = this.moduleButtonService.getList(menuId, pagination);
        List treeList = JsonUtil.getJsonToList(data, ButtonTreeListModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)treeList);
        if (data.size() > sumTrees.size()) {
            List list = JsonUtil.getJsonToList((Object)sumTrees, ButtonTreeListVO.class);
            ListVO treeVo = new ListVO();
            treeVo.setList(list);
            return ActionResult.success((Object)treeVo);
        }
        List list = JsonUtil.getJsonToList((Object)treeList, ButtonListVO.class);
        ListVO treeVo1 = new ListVO();
        treeVo1.setList(list);
        return ActionResult.success((Object)treeVo1);
    }

    @Operation(summary="\u83b7\u53d6\u6309\u94ae\u6743\u9650\u4e0b\u62c9\u6846")
    @GetMapping(value={"/{menuId}/Selector"})
    public ActionResult<ListVO<ButtonTreeListVO>> selectList(@PathVariable(value="menuId") String menuId) {
        List<ModuleButtonEntity> data = this.moduleButtonService.getList(menuId);
        List treeList = JsonUtil.getJsonToList(data, ButtonTreeListModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)treeList);
        List list = JsonUtil.getJsonToList((Object)sumTrees, ButtonTreeListVO.class);
        ListVO treeVo = new ListVO();
        treeVo.setList(list);
        return ActionResult.success((Object)treeVo);
    }

    @Operation(summary="\u83b7\u53d6\u6309\u94ae\u6743\u9650\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<ModuleButtonInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ModuleButtonEntity entity = this.moduleButtonService.getInfo(id);
        ModuleButtonInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, ModuleButtonInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u65b0\u5efa\u6309\u94ae\u6743\u9650")
    @PostMapping
    public ActionResult create(@RequestBody ModuleButtonCrForm moduleButtonCrForm) {
        ModuleButtonEntity entity = (ModuleButtonEntity)JsonUtil.getJsonToBean((Object)moduleButtonCrForm, ModuleButtonEntity.class);
        if (this.moduleButtonService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        this.moduleButtonService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u66f4\u65b0\u6309\u94ae\u6743\u9650")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody ModuleButtonUpForm moduleButtonUpForm) {
        ModuleButtonEntity entity = (ModuleButtonEntity)JsonUtil.getJsonToBean((Object)moduleButtonUpForm, ModuleButtonEntity.class);
        if (this.moduleButtonService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        boolean flag = this.moduleButtonService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u5220\u9664\u6309\u94ae\u6743\u9650")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ModuleButtonEntity entity = this.moduleButtonService.getInfo(id);
        if (entity != null) {
            this.moduleButtonService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @Operation(summary="\u66f4\u65b0\u83dc\u5355\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult upState(@PathVariable(value="id") String id) {
        ModuleButtonEntity entity = this.moduleButtonService.getInfo(id);
        if (entity.getEnabledMark() == null || "1".equals(String.valueOf(entity.getEnabledMark()))) {
            entity.setEnabledMark(0);
        } else {
            entity.setEnabledMark(1);
        }
        boolean flag = this.moduleButtonService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }
}

