/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.ColumnDataModel;
import com.bringspring.common.model.visiual.ColumnListField;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.entity.ModuleColumnEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.model.column.ColumnBatchForm;
import com.bringspring.system.base.model.column.ColumnListVO;
import com.bringspring.system.base.model.column.ModuleColumnCrForm;
import com.bringspring.system.base.model.column.ModuleColumnInfoVO;
import com.bringspring.system.base.model.column.ModuleColumnUpForm;
import com.bringspring.system.base.model.module.PropertyJsonModel;
import com.bringspring.system.base.service.ModuleColumnService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5217\u8868\u6743\u9650")
@Validated
@RestController
@RequestMapping(value={"/api/system/ModuleColumn"})
public class ModuleColumnController {
    @Autowired
    private ModuleColumnService moduleColumnService;
    @Autowired
    private ModuleService moduleService;

    @Operation(summary="\u83b7\u53d6\u5217\u8868\u6743\u9650\u5217\u8868")
    @GetMapping(value={"/{moduleId}/Fields"})
    public ActionResult getList(@PathVariable(value="moduleId") String moduleId, Pagination pagination) {
        List<ModuleColumnEntity> list = this.moduleColumnService.getList(moduleId, pagination);
        List voList = JsonUtil.getJsonToList(list, ColumnListVO.class);
        voList.stream().forEach(t -> {
            if (StringUtils.isNotEmpty((String)t.getEnCode())) {
                t.setEnCode(StringUtils.isNotEmpty((String)t.getEnCode()) ? t.getEnCode().replace("jsbos_" + t.getBindTable() + "_jsbos_", "") : "");
            }
        });
        ListVO vo = new ListVO();
        vo.setList(voList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83dc\u5355\u5217\u8868\u6743\u9650")
    @GetMapping(value={"/{moduleId}/FieldList"})
    public ActionResult fieldList(@PathVariable(value="moduleId") String moduleId) {
        ArrayList list = new ArrayList();
        ModuleEntity entity = this.moduleService.getInfo(moduleId);
        if (entity != null) {
            PropertyJsonModel model = (PropertyJsonModel)JsonUtil.getJsonToBean((String)entity.getPropertyJson(), PropertyJsonModel.class);
            if (model == null) {
                model = new PropertyJsonModel();
            }
            Object bean = SpringContext.getBean((String)"visualdevServiceImpl");
            Object method = ReflectionUtil.invokeMethod((Object)bean, (String)"getInfo", (Class[])new Class[]{String.class}, (Object[])new Object[]{model.getModuleId()});
            Map map = JsonUtil.entityToMap((Object)method);
            boolean isPc = entity.getCategory().equalsIgnoreCase("web");
            if (map != null) {
                ColumnDataModel columnDataModel;
                List columnListFields;
                Object columnData;
                Object v = columnData = isPc ? map.get("columnData") : map.get("appColumnData");
                if (Objects.nonNull(columnData) && Objects.nonNull(columnListFields = JsonUtil.getJsonToList((String)(columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData.toString(), ColumnDataModel.class)).getDefaultColumnList(), ColumnListField.class))) {
                    columnListFields.stream().forEach(col -> {
                        HashMap<String, String> dataMap = new HashMap<String, String>();
                        dataMap.put("field", col.getProp());
                        dataMap.put("fieldName", col.getLabel());
                        list.add(dataMap);
                    });
                }
            }
        }
        return ActionResult.success(list);
    }

    @Operation(summary="\u83b7\u53d6\u5217\u8868\u6743\u9650\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<ModuleColumnInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ModuleColumnEntity entity = this.moduleColumnService.getInfo(id);
        ModuleEntity moduleEntity = this.moduleService.getInfo(entity.getModuleId());
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            entity.setEnCode(entity.getEnCode().replace("jsbos_" + entity.getBindTable() + "_jsbos_", ""));
        }
        ModuleColumnInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, ModuleColumnInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u65b0\u5efa\u5217\u8868\u6743\u9650")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ModuleColumnCrForm moduleColumnCrForm) {
        ModuleEntity moduleEntity = this.moduleService.getInfo(moduleColumnCrForm.getModuleId());
        ModuleColumnEntity entity = (ModuleColumnEntity)JsonUtil.getJsonToBean((Object)moduleColumnCrForm, ModuleColumnEntity.class);
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            String enCode = "jsbos_" + entity.getBindTable() + "_jsbos_" + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        if (this.moduleColumnService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        this.moduleColumnService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u66f4\u65b0\u5217\u8868\u6743\u9650")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ModuleColumnUpForm moduleColumnUpForm) {
        ModuleEntity moduleEntity = this.moduleService.getInfo(moduleColumnUpForm.getModuleId());
        ModuleColumnEntity entity = (ModuleColumnEntity)JsonUtil.getJsonToBean((Object)moduleColumnUpForm, ModuleColumnEntity.class);
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            String enCode = "jsbos_" + entity.getBindTable() + "_jsbos_" + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        if (this.moduleColumnService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), id)) {
            return ActionResult.fail((String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.moduleColumnService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u5220\u9664\u5217\u8868\u6743\u9650")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ModuleColumnEntity entity = this.moduleColumnService.getInfo(id);
        if (entity != null) {
            this.moduleColumnService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @Operation(summary="\u66f4\u65b0\u5217\u8868\u6743\u9650\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult upState(@PathVariable(value="id") String id) {
        ModuleColumnEntity entity = this.moduleColumnService.getInfo(id);
        if (entity.getEnabledMark() == null || "1".equals(String.valueOf(entity.getEnabledMark()))) {
            entity.setEnabledMark(0);
        } else {
            entity.setEnabledMark(1);
        }
        boolean flag = this.moduleColumnService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u6279\u91cf\u65b0\u5efa\u5217\u8868\u6743\u9650")
    @PostMapping(value={"/Actions/Batch"})
    public ActionResult batchCreate(@RequestBody @Valid ColumnBatchForm columnBatchForm) {
        List<ModuleColumnEntity> entitys = columnBatchForm.getColumnJson() != null ? JsonUtil.getJsonToList((Object)columnBatchForm.getColumnJson(), ModuleColumnEntity.class) : new ArrayList();
        ArrayList<String> name = new ArrayList<String>();
        for (ModuleColumnEntity entity : entitys) {
            entity.setModuleId(columnBatchForm.getModuleId());
            if (this.moduleColumnService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), null)) {
                return ActionResult.fail((String)MsgCode.EXIST002.get());
            }
            if (name.contains(entity.getEnCode())) {
                return ActionResult.fail((String)MsgCode.EXIST002.get());
            }
            name.add(entity.getEnCode());
        }
        this.moduleColumnService.create(entitys);
        return ActionResult.success((String)MsgCode.SU001.get());
    }
}

