/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaMode;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.model.online.BatchOnlineModel;
import com.bringspring.system.base.service.UserOnlineService;
import com.bringspring.system.message.model.UserOnlineModel;
import com.bringspring.system.message.model.UserOnlineVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5728\u7ebf\u7528\u6237")
@RestController
@RequestMapping(value={"/api/system/OnlineUser"})
public class UserOnlineController {
    @Autowired
    private UserOnlineService userOnlineService;

    @Operation(summary="\u83b7\u53d6\u5728\u7ebf\u7528\u6237\u5217\u8868")
    @SaCheckPermission(value={"permission.userOnline", "monitor.userOnline"}, mode=SaMode.OR)
    @GetMapping
    public ActionResult<PageListVO<UserOnlineVO>> list(Pagination page) {
        List<UserOnlineModel> data = this.userOnlineService.getList(page);
        List voList = data.stream().map(online -> {
            UserOnlineVO vo = (UserOnlineVO)JsonUtil.getJsonToBean((Object)online, UserOnlineVO.class);
            vo.setUserId(online.getToken());
            return vo;
        }).collect(Collectors.toList());
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)page, PaginationVO.class);
        return ActionResult.page(voList, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u5f3a\u5236\u4e0b\u7ebf")
    @Parameter(name="token", description="token", required=true)
    @SaCheckPermission(value={"permission.userOnline"})
    @DeleteMapping(value={"/{token}"})
    public ActionResult delete(@PathVariable(value="token") String token) {
        this.userOnlineService.delete(token);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @Operation(summary="\u6279\u91cf\u4e0b\u7ebf\u7528\u6237")
    @Parameter(name="model", description="\u5728\u7ebf\u7528\u6237id\u96c6\u5408", required=true)
    @SaCheckPermission(value={"permission.userOnline"})
    @DeleteMapping
    public ActionResult clear(@RequestBody BatchOnlineModel model) {
        this.userOnlineService.delete(model.getIds());
        return ActionResult.success((String)MsgCode.SU005.get());
    }
}

