/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.listener;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.systemconfig.SysConfigCropModel;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.model.dingding.DingDeptModel;
import com.bringspring.system.base.model.dingding.DingUserIdModel;
import com.bringspring.system.base.model.dingding.DingUserModel;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.service.SynThirdQyService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiV2DepartmentGetRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiV2DepartmentGetResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.dingtalk.open.app.api.GenericEventListener;
import com.dingtalk.open.app.api.OpenDingTalkStreamClientBuilder;
import com.dingtalk.open.app.api.message.GenericOpenDingTalkEvent;
import com.dingtalk.open.app.api.security.AuthClientCredential;
import com.dingtalk.open.app.api.security.DingTalkCredential;
import com.dingtalk.open.app.stream.protocol.event.EventAckStatus;
import com.taobao.api.TaobaoRequest;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apdplat.word.tagging.PinyinTagging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class DIngStream
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DIngStream.class);
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private SynThirdQyService synThirdQyService;
    @Autowired
    private SynThirdDingTalkService synThirdDingTalkService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext().getParent();
    }

    public void dingStream() throws Exception {
        SysConfigEntity dingCom = this.sysConfigService.getConfigByKeyName("dingCom");
        if (ObjectUtil.isNotNull((Object)dingCom)) {
            List jsonToList = JsonUtil.getJsonToList((String)String.valueOf(dingCom.getKeyValue()), SysConfigCropModel.class);
            SysConfigCropModel sysConfigCropModel = (SysConfigCropModel)jsonToList.get(0);
            final String corpId = sysConfigCropModel.getClientId();
            String corpSecret = sysConfigCropModel.getClientSecrent();
            OpenDingTalkStreamClientBuilder.custom().credential((DingTalkCredential)new AuthClientCredential(corpId, corpSecret)).registerAllEventListener(new GenericEventListener(){

                public EventAckStatus onEvent(GenericOpenDingTalkEvent event) {
                    try {
                        String eventId = event.getEventId();
                        String eventType = event.getEventType();
                        Long bornTime = event.getEventBornTime();
                        JSONObject bizData = event.getData();
                        if ("org_dept_create".equals(eventType) || "org_dept_modify".equals(eventType)) {
                            DIngStream.this.orgChange(bizData, corpId);
                        } else if ("user_add_org".equals(eventType) || "user_modify_org".equals(eventType)) {
                            DIngStream.this.userChange(bizData, corpId);
                        }
                        PinyinTagging.process((List)((List)bizData));
                        return EventAckStatus.SUCCESS;
                    }
                    catch (Exception e) {
                        return EventAckStatus.LATER;
                    }
                }
            }).build().start();
        }
    }

    public void userChange(JSONObject bizData, String corpId) throws Exception {
        this.userAOD(((DingUserIdModel)JsonUtil.getJsonToBean((Object)bizData, DingUserIdModel.class)).getUserId().get(0), corpId);
    }

    public DingUserModel userAOD(String userId, String qyhCorpId) throws Exception {
        List<SynThirdInfoEntity> infoByThirdObjIds;
        List first;
        List<SynThirdInfoEntity> listThird = this.synThirdInfoService.getList("1", "2");
        List<RoleEntity> listByEnCode = this.roleService.getListByEnCode("SimpleUser");
        UserInfo userInfo = this.userProvider.get();
        DefaultDingTalkClient clientUser = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
        OapiV2UserGetRequest reqUser = new OapiV2UserGetRequest();
        reqUser.setUserid(userId);
        OapiV2UserGetResponse rspUser = (OapiV2UserGetResponse)clientUser.execute((TaobaoRequest)reqUser, this.dingAssisToken());
        DingUserModel map = (DingUserModel)JsonUtil.getJsonToBean((String)String.valueOf(JsonUtil.stringToMap((String)rspUser.getBody()).get("result")), DingUserModel.class);
        map.setDepartmentId(map.getDept_id_list().get(0));
        System.out.println(rspUser.getBody());
        UserEntity userEntity = new UserEntity();
        String userid = String.valueOf(map.getUserid());
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        if (!StringUtils.isNull((Object)map.getUserid()) && !ObjectUtil.isEmpty(first = listThird.stream().filter(n -> userid.equals(n.getThirdObjectId())).collect(Collectors.toList()))) {
            synThirdInfoEntity = (SynThirdInfoEntity)first.get(0);
            if (null != synThirdInfoEntity) {
                userEntity.setId(synThirdInfoEntity.getSystemObjectId());
            } else {
                userEntity.setId(RandomUtil.uuId());
                synThirdInfoEntity = new SynThirdInfoEntity();
                synThirdInfoEntity.setId(RandomUtil.uuId());
            }
        }
        if (!StringUtils.isNull((Object)map.getName())) {
            userEntity.setRealName(map.getName().replaceAll("[^\u4e00-\u9fa5]", ""));
        }
        if (!StringUtils.isNull((Object)map.getNickname())) {
            userEntity.setNickName(map.getNickname());
        }
        if (!StringUtils.isNull((Object)map.getUserid())) {
            userEntity.setAccount(map.getUserid());
        }
        if (!StringUtils.isNull((Object)map.getDepartmentId())) {
            List infoByThirdObjId = this.synThirdInfoService.getInfoByThirdObjIds("2", "1", map.getDepartmentId()).stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList());
            if (!ObjectUtil.isEmpty(infoByThirdObjId)) {
                userEntity.setOrganizeId(((SynThirdInfoEntity)infoByThirdObjId.get(0)).getSystemObjectId());
            } else {
                userEntity.setOrganizeId(map.getDepartmentId());
            }
        }
        if (!StringUtils.isNull((Object)map.getMobile())) {
            userEntity.setMobilePhone(map.getMobile());
        }
        if (!StringUtils.isNull((Object)map.getEmail())) {
            userEntity.setEmail(map.getEmail());
        }
        if (!StringUtils.isNull((Object)map.getWork_place())) {
            userEntity.setPostalAddress(map.getWork_place());
        }
        userEntity.setGender(3);
        if (!StringUtils.isNull((Object)map.getManager_userid())) {
            userEntity.setManagerId(map.getManager_userid());
        }
        userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
        userEntity.setEnabledMark(1);
        userEntity.setRoleId(listByEnCode.get(0).getId());
        OrganizeEntity orgInfo = this.organizeService.getInfo(qyhCorpId + map.getDepartmentId());
        if (ObjectUtil.isNotEmpty((Object)orgInfo)) {
            OrganizeEntity companyInfo = this.organizeService.getInfo(orgInfo.getOrganizeId());
            if (!ObjectUtil.isEmpty((Object)companyInfo)) {
                enCode = companyInfo.getEnCode() + "Staff";
                billNumber = this.baseDataUtil.getBillNumber((String)enCode, false);
                userEntity.setCode(billNumber);
            } else {
                enCode = "RStaff";
                billNumber = this.baseDataUtil.getBillNumber((String)enCode, false);
                userEntity.setCode(billNumber);
            }
        }
        if (ObjectUtil.isEmpty(infoByThirdObjIds = this.synThirdInfoService.getInfoByThirdObjIds("2", "2", map.getUserid()))) {
            userEntity.setId(qyhCorpId + map.getUserid());
            this.userService.createUser(userEntity);
            synThirdInfoEntity.setThirdObjectId(String.valueOf(map.getUserid()));
            synThirdInfoEntity.setSystemObjectId(userEntity.getId());
            synThirdInfoEntity.setThirdType(Integer.valueOf("2"));
            synThirdInfoEntity.setDataType(Integer.valueOf("2"));
            synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
            SysConfigEntity dingCom = this.sysConfigService.getConfigByKeyName("dingCom");
            List jsonToList = JsonUtil.getJsonToList((String)String.valueOf(dingCom.getKeyValue()), SysConfigCropModel.class);
            SysConfigCropModel sysConfigCropModel = (SysConfigCropModel)jsonToList.get(0);
            String corpId = sysConfigCropModel.getClientId();
            synThirdInfoEntity.setCropId(corpId);
            synThirdInfoEntity.setCreatorUserId(userInfo.getUserId());
            synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate());
            this.synThirdInfoService.saveOrUpdate(synThirdInfoEntity);
        } else {
            userEntity.setId(infoByThirdObjIds.get(0).getSystemObjectId());
            boolean bl = this.userService.update(userEntity);
        }
        return null;
    }

    public void orgChange(JSONObject bizData, String cropId) throws Exception {
        JsonUtil.getJsonToBean((Object)bizData, DingUserIdModel.class);
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/get");
        OapiV2DepartmentGetRequest req = new OapiV2DepartmentGetRequest();
        req.setDeptId(((DingUserIdModel)JsonUtil.getJsonToBean((Object)bizData, DingUserIdModel.class)).getDeptid().get(0));
        OapiV2DepartmentGetResponse rsp = (OapiV2DepartmentGetResponse)client.execute((TaobaoRequest)req, this.dingAssisToken());
        System.out.println(rsp.getBody());
        DingDeptModel resultDepart = (DingDeptModel)JsonUtil.getJsonToBean((String)String.valueOf(JsonUtil.stringToMap((String)rsp.getBody()).get("result")), DingDeptModel.class);
        ArrayList<DingDeptModel> resultDepartList = new ArrayList<DingDeptModel>();
        resultDepartList.add(resultDepart);
        this.orgAOD(resultDepartList, cropId);
    }

    public ActionResult orgAOD(List<DingDeptModel> resultDepart, String cropId) {
        Object organize = "";
        for (DingDeptModel v : resultDepart) {
            List<SynThirdInfoEntity> infoByThirdObjIds = this.synThirdInfoService.getInfoByThirdObjIds("2", "1", v.getDept_id());
            OrganizeEntity entityAdd = new OrganizeEntity();
            entityAdd.setId(cropId + v.getDept_id());
            entityAdd.setFullName(v.getName());
            entityAdd.setParentId(cropId + v.getParent_id());
            if ("1".equals(String.valueOf(v.getDept_id()))) {
                entityAdd.setCategory("company");
                entityAdd.setEnCode("R");
                entityAdd.setParentId("0");
                organize = cropId + v.getDept_id();
            } else {
                entityAdd.setCategory("department");
            }
            entityAdd.setOrganizeId(cropId + v.getParent_id());
            if (ObjectUtil.isEmpty(infoByThirdObjIds)) {
                this.synThirdQyService.createOrgan(entityAdd);
                SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
                synThirdInfoEntity.setThirdObjectId(v.getDept_id());
                synThirdInfoEntity.setSystemObjectId(entityAdd.getId());
                synThirdInfoEntity.setThirdType(Integer.valueOf("2"));
                synThirdInfoEntity.setDataType(Integer.valueOf("1"));
                synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                synThirdInfoEntity.setCreatorUserId(this.userProvider.get().getUserId());
                synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate());
                synThirdInfoEntity.setId(RandomUtil.uuId());
                synThirdInfoEntity.setCropId(cropId);
                this.synThirdInfoService.saveOrUpdate(synThirdInfoEntity);
                continue;
            }
            OrganizeEntity entityEdit = new OrganizeEntity();
            entityEdit.setId(infoByThirdObjIds.get(0).getSystemObjectId());
            this.organizeService.update(entityAdd.getId(), entityAdd);
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        this.setOrganizeCode();
        this.setOrganizedTree();
        return ActionResult.success((Object)synThirdTotal);
    }

    public String dingAssisToken() throws Exception {
        DefaultDingTalkClient clientToken = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
        OapiGettokenRequest req = new OapiGettokenRequest();
        SysConfigEntity dingCom = this.sysConfigService.getConfigByKeyName("dingCom");
        List jsonToList = JsonUtil.getJsonToList((String)String.valueOf(dingCom.getKeyValue()), SysConfigCropModel.class);
        SysConfigCropModel sysConfigCropModel = (SysConfigCropModel)jsonToList.get(0);
        String corpId = sysConfigCropModel.getClientId();
        String corpSecret = sysConfigCropModel.getClientSecrent();
        req.setAppkey(corpId);
        req.setAppsecret(corpSecret);
        req.setHttpMethod("GET");
        OapiGettokenResponse rsp = (OapiGettokenResponse)clientToken.execute((TaobaoRequest)req);
        System.out.println(rsp.getBody());
        Map stringObjectMap = JsonUtil.stringToMap((String)rsp.getBody());
        if (!stringObjectMap.containsKey("access_token")) {
            throw new Exception("\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        return String.valueOf(stringObjectMap.get("access_token"));
    }

    public void setOrganizeCode() {
        List<OrganizeEntity> orgListCodeNull = this.organizeService.getOrgListCodeNull();
        if (ObjectUtil.isNotEmpty(orgListCodeNull)) {
            orgListCodeNull.stream().forEach(item -> {
                if (!"company".equals(item.getCategory())) {
                    this.setCode((OrganizeEntity)item);
                }
            });
        }
    }

    public void setCode(OrganizeEntity entity) {
        OrganizeEntity parentEntity = this.organizeService.getInfo(entity.getParentId());
        if (!ObjectUtil.isEmpty((Object)parentEntity)) {
            if (ObjectUtil.isNotEmpty((Object)parentEntity.getEnCode())) {
                List<OrganizeEntity> parentIdList = this.organizeService.getParentIdListAsc(entity.getParentId());
                if (ObjectUtil.isNotEmpty(parentIdList) && ObjectUtil.isNotEmpty((Object)parentIdList.get(0).getEnCode())) {
                    String enCode1 = parentIdList.get(0).getEnCode();
                    String ul = enCode1.replaceAll("[a-zA-Z]", "");
                    int utellength = ul.length();
                    Object u = "";
                    for (int i = 0; i < utellength; ++i) {
                        u = (String)u + "0";
                    }
                    BigInteger utel = new BigInteger(ul);
                    BigInteger untel = new BigInteger(String.valueOf("1"));
                    utel = utel.add(untel);
                    DecimalFormat nf = new DecimalFormat((String)u);
                    String str = nf.format(utel);
                    String enCode = parentEntity.getEnCode();
                    entity.setEnCode(enCode.charAt(0) + str);
                } else {
                    entity.setEnCode(parentEntity.getEnCode() + "01");
                }
            } else {
                this.setCode(parentEntity);
            }
            this.organizeService.update(entity);
        }
    }

    public void setOrganizedTree() {
        List<OrganizeEntity> listOrgan = this.organizeService.getList();
        List collectCompany = listOrgan.stream().filter(i -> "company".equals(i.getCategory())).map(v -> v.getId()).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(listOrgan)) {
            for (OrganizeEntity item : listOrgan) {
                String organizeIdTree = this.organizeService.getOrganizeIdTreeALL(item);
                List<String> listTree = Arrays.asList(organizeIdTree.split(","));
                List collectOrg = listTree.stream().filter(collectCompany::contains).collect(Collectors.toList());
                String organizeId = "0";
                if (!ObjectUtil.isEmpty(collectOrg)) {
                    organizeId = (String)collectOrg.get(collectOrg.size() - 1);
                }
                item.setOrganizeIdTree(organizeIdTree);
                item.setOrganizeId(organizeId);
            }
            this.organizeService.updateBatchById(listOrgan);
        }
    }

    public void setOrganizedTree(String corpId) {
        List<SynThirdInfoEntity> listByCrop = this.synThirdInfoService.getListByCrop("1", "1", corpId);
        List<String> idList = listByCrop.stream().map(SynThirdInfoEntity::getSystemObjectId).collect(Collectors.toList());
        List<OrganizeEntity> listOrgan = this.organizeService.getListAll(idList, null);
        List collectCompany = listOrgan.stream().filter(i -> "company".equals(i.getCategory())).map(v -> v.getId()).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(listOrgan)) {
            for (OrganizeEntity item : listOrgan) {
                String organizeIdTree = this.organizeService.getOrganizeIdTreeALL(item);
                List<String> listTree = Arrays.asList(organizeIdTree.split(","));
                List collectOrg = listTree.stream().filter(collectCompany::contains).collect(Collectors.toList());
                String organizeId = "0";
                if (!ObjectUtil.isEmpty(collectOrg)) {
                    organizeId = (String)collectOrg.get(collectOrg.size() - 1);
                }
                item.setOrganizeIdTree(organizeIdTree);
                item.setOrganizeId(organizeId);
            }
            this.organizeService.updateBatchById(listOrgan);
        }
    }
}

