/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.BaseVersionEntity;
import com.bringspring.system.base.enums.BaseVersionSendMarkEnum;
import com.bringspring.system.base.enums.EnabledMarkEnum;
import com.bringspring.system.base.mapper.BaseVersionMapper;
import com.bringspring.system.base.model.baseversion.BaseVersionCrForm;
import com.bringspring.system.base.model.baseversion.BaseVersionPagination;
import com.bringspring.system.base.model.baseversion.BaseVersionUpForm;
import com.bringspring.system.base.service.BaseVersionService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.RangeService;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseVersionServiceImpl
extends ServiceImpl<BaseVersionMapper, BaseVersionEntity>
implements BaseVersionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseVersionServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RangeService rangeService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private UserService userService;

    @Override
    public List<BaseVersionEntity> getList(BaseVersionPagination baseVersionPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int baseVersionNum = 0;
        QueryWrapper baseVersionQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getTitle())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getTitle, (Object)baseVersionPagination.getTitle());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getVersion())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getVersion, (Object)baseVersionPagination.getVersion());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getSendType())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().eq(BaseVersionEntity::getSendType, (Object)baseVersionPagination.getSendType());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getSendRange())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getSendRange, (Object)baseVersionPagination.getSendRange());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getDescription())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getDescription, (Object)baseVersionPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getEnabledMark())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().eq(BaseVersionEntity::getEnabledMark, (Object)baseVersionPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            baseVersionQueryWrapper.lambda().in(BaseVersionEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)baseVersionPagination.getSidx())) {
            baseVersionQueryWrapper.lambda().orderByDesc(BaseVersionEntity::getId);
        } else {
            try {
                String sidx = baseVersionPagination.getSidx();
                BaseVersionEntity baseVersionEntity = new BaseVersionEntity();
                Field declaredField = baseVersionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                baseVersionQueryWrapper = "asc".equals(baseVersionPagination.getSort().toLowerCase()) ? (QueryWrapper)baseVersionQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)baseVersionQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(baseVersionPagination.getCurrentPage(), baseVersionPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)baseVersionQueryWrapper);
            return baseVersionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return baseVersionPagination.setData(list, list.size());
    }

    @Override
    public List<BaseVersionEntity> getTypeList(BaseVersionPagination baseVersionPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int baseVersionNum = 0;
        QueryWrapper baseVersionQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getTitle())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getTitle, (Object)baseVersionPagination.getTitle());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getVersion())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getVersion, (Object)baseVersionPagination.getVersion());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getSendType())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().eq(BaseVersionEntity::getSendType, (Object)baseVersionPagination.getSendType());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getSendRange())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getSendRange, (Object)baseVersionPagination.getSendRange());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getDescription())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getDescription, (Object)baseVersionPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)baseVersionPagination.getEnabledMark())) {
            ++baseVersionNum;
            baseVersionQueryWrapper.lambda().eq(BaseVersionEntity::getEnabledMark, (Object)baseVersionPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            baseVersionQueryWrapper.lambda().in(BaseVersionEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)baseVersionPagination.getSidx())) {
            baseVersionQueryWrapper.lambda().orderByDesc(BaseVersionEntity::getId);
        } else {
            try {
                String sidx = baseVersionPagination.getSidx();
                BaseVersionEntity baseVersionEntity = new BaseVersionEntity();
                Field declaredField = baseVersionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                baseVersionQueryWrapper = "asc".equals(baseVersionPagination.getSort().toLowerCase()) ? (QueryWrapper)baseVersionQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)baseVersionQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(baseVersionPagination.getCurrentPage(), baseVersionPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)baseVersionQueryWrapper);
                return baseVersionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return baseVersionPagination.setData(list, list.size());
        }
        return this.list((Wrapper)baseVersionQueryWrapper);
    }

    @Override
    public BaseVersionEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseVersionEntity::getId, (Object)id);
        return (BaseVersionEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(BaseVersionCrForm baseVersionCrForm) {
        String mainId = RandomUtil.uuId();
        BaseVersionEntity entity = (BaseVersionEntity)JsonUtil.getJsonToBean((Object)baseVersionCrForm, BaseVersionEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, BaseVersionUpForm baseVersionUpForm) {
        UserInfo userInfo = this.userProvider.get();
        BaseVersionEntity entity = this.getInfo(id);
        if (entity != null) {
            BaseVersionEntity subentity = (BaseVersionEntity)JsonUtil.getJsonToBean((Object)baseVersionUpForm, BaseVersionEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public ActionResult release(String id) {
        UserInfo userInfo = this.userProvider.get();
        BaseVersionEntity entity = this.getInfo(id);
        entity.setId(id);
        entity.setEnabledMark(EnabledMarkEnum.RELEASED.getStatus());
        entity.setSendTime(new Date());
        entity.setSendUserId(userInfo.getUserId());
        if (entity.getSendType().equals("1") || entity.getSendType().equals("2")) {
            this.send(entity);
        }
        this.updateById(entity);
        return ActionResult.success((String)"\u53d1\u5e03\u6210\u529f");
    }

    @Override
    public void send(BaseVersionEntity entity) {
        entity.setIsSend(BaseVersionSendMarkEnum.SEND.getStatus());
        entity.setSendUserId(this.userProvider.get().getUserId());
        String taskCode = "\u7cfb\u7edf\u7248\u672c\u5347\u7ea7\u901a\u77e5";
        String sendCode = "Version";
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", entity.getTitle());
        keys.put("tip", "\uff08\u7248\u672c\uff1aV" + entity.getVersion() + "\uff09");
        keys.put("content", "\u66f4\u65b0\u5185\u5bb9\uff1a\n" + entity.getContent());
        keys.put("tag", "\u66f4\u65b0\u65e5\u671f\uff1a" + DateUtil.today());
        keys.put("sendUser", entity.getSendUserId());
        keys.put("sendTime", com.bringspring.common.util.DateUtil.getNow());
        keys.put("isNewDialog", "1");
        List<String> toUserIds = CollectionUtil.list((boolean)false);
        if (entity.getSendType().equals("1")) {
            toUserIds = this.userService.getListId();
        } else if (entity.getSendType().equals("2")) {
            String sendRange = entity.getSendRange();
            List<UserEntity> rangeUserList = this.rangeService.getRangeUserList(sendRange);
            toUserIds = rangeUserList.stream().map(UserEntity::getId).collect(Collectors.toList());
        }
        this.sendMessageNew(taskCode, sendCode, keys, null, null, null, CollectionUtil.join(toUserIds, (CharSequence)","), TermTypeEnum.TERM_APP_PC.getCode(), null);
    }

    @Override
    public BaseVersionEntity getVersion() {
        return ((BaseVersionMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().orderByDesc(BaseVersionEntity::getCreatorTime)).last("LIMIT 1")).stream().findFirst().orElse(null);
    }

    public void sendMessageNew(String taskCode, String sendCode, HashMap<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId, String termType, String typeDesc) {
        log.info("code:{},\u63a5\u6536\u4eba:{}", (Object)sendCode, (Object)userId);
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode(taskCode);
        taskMsg.setSendCode(sendCode);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setKeys(keys);
        linkMsgKeys.setLinkUrl("");
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(termType);
        customKeysLink.setTermTypeDesc(typeDesc);
        customKeysLink.setPcUrl(pcUrl);
        customKeysLink.setAppUrl(appUrl);
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setBusinessKey(linkMsgKeys);
        taskMsg.setToUserIds(userId);
        try {
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    @DSTransactional
    public void delete(BaseVersionEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

