/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.SmsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SmsTemplateEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.mapper.SmsTemplateMapper;
import com.bringspring.system.base.service.SmsTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsTemplateServiceImpl
extends ServiceImpl<SmsTemplateMapper, SmsTemplateEntity>
implements SmsTemplateService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;

    @Override
    public List<SmsTemplateEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SmsTemplateEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByDesc(SmsTemplateEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SmsTemplateEntity> getList(Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(SmsTemplateEntity::getTemplateId, (Object)pagination.getKeyword())).or()).like(SmsTemplateEntity::getFullName, (Object)pagination.getKeyword())).or()).like(SmsTemplateEntity::getEnCode, (Object)pagination.getKeyword()));
        }
        queryWrapper.lambda().orderByDesc(SmsTemplateEntity::getCreatorTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public SmsTemplateEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SmsTemplateEntity::getId, (Object)id);
        return (SmsTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(SmsTemplateEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String id, SmsTemplateEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(SmsTemplateEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public boolean isExistByTemplateName(String templateName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SmsTemplateEntity::getFullName, (Object)templateName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(SmsTemplateEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SmsTemplateEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(SmsTemplateEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public SmsModel getSmsConfig() {
        List<SysConfigEntity> configList = this.sysConfigService.getList();
        HashMap<String, String> objModel = new HashMap<String, String>(16);
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        SmsModel smsModel = (SmsModel)JsonUtil.getJsonToBean(objModel, SmsModel.class);
        return smsModel;
    }
}

