/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util;

import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.model.FileModel;
import com.bringspring.common.util.FileUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileManageUtil {
    @Autowired
    private ConfigValueUtil configValueUtil;

    public void createFile(List<FileModel> data) {
        if (data != null && data.size() > 0) {
            String temporaryFilePath = this.configValueUtil.getTemporaryFilePath();
            String systemFilePath = this.configValueUtil.getSystemFilePath();
            for (FileModel item : data) {
                FileUtil.copyFile((String)(temporaryFilePath + item.getFileId()), (String)(systemFilePath + item.getFileId()));
            }
        }
    }

    public void updateFile(List<FileModel> data) {
        if (data != null && data.size() > 0) {
            String temporaryFilePath = this.configValueUtil.getTemporaryFilePath();
            String systemFilePath = this.configValueUtil.getSystemFilePath();
            for (FileModel item : data) {
                if ("add".equals(item.getFileType())) {
                    FileUtil.copyFile((String)(temporaryFilePath + item.getFileId()), (String)(systemFilePath + item.getFileId()));
                    continue;
                }
                if (!"delete".equals(item.getFileType())) continue;
                FileUtil.deleteFile((String)(systemFilePath + item.getFileId()));
            }
        }
    }

    public void deleteFile(List<FileModel> data) {
        if (data != null && data.size() > 0) {
            String systemFilePath = this.configValueUtil.getSystemFilePath();
            for (FileModel item : data) {
                FileUtil.deleteFile((String)(systemFilePath + item.getFileId()));
            }
        }
    }
}

