/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.IKeyWordsHandler;
import com.baomidou.mybatisplus.generator.config.querys.PostgreSqlQuery;
import com.baomidou.mybatisplus.generator.keywords.MySqlKeyWordsHandler;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbPostgre;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.TenantHolder;

public class SourceUtil {
    public static DataSourceConfig dbConfig(String dbName, DataSourceUtil linkEntity) {
        if (linkEntity == null && !"KingbaseES".equals((linkEntity = TenantDataSourceUtil.isTenantAssignDataSource() ? (DataSourceUtil)TenantDataSourceUtil.getTenantAssignDataSource((String)TenantHolder.getDatasourceId()).toDbLink((Object)new DbLinkEntity()) : DynamicDataSourceUtil.dataSourceUtil.init()).getDbType()) && !"PostgreSQL".equals(linkEntity.getDbType()) && StringUtils.isNotEmpty((String)dbName)) {
            linkEntity.setDbName(dbName);
        }
        try {
            DbBase dbBase = DbTypeUtil.getDb((DbSourceOrDbLink)linkEntity);
            DbType mpDbType = dbBase.getMpDbType();
            String userName = linkEntity.getUserName();
            String password = linkEntity.getPassword();
            String dbSchema = linkEntity.getDbSchema();
            if (StringUtils.isEmpty((String)dbSchema) && (mpDbType.getDb().equalsIgnoreCase(DbType.ORACLE.getDb()) || mpDbType.getDb().equalsIgnoreCase(DbType.KINGBASE_ES.getDb()) || mpDbType.getDb().equalsIgnoreCase(DbType.DM.getDb()))) {
                dbSchema = linkEntity.getUserName();
                if (StringUtils.isNotEmpty((String)dbName)) {
                    dbSchema = dbName;
                }
            }
            if (mpDbType.getDb().equalsIgnoreCase(DbType.POSTGRE_SQL.getDb())) {
                dbSchema = StringUtils.isNotEmpty((String)dbName) ? dbName : (StringUtils.isNotEmpty((String)linkEntity.getDbSchema()) ? linkEntity.getDbSchema() : DbPostgre.DEF_SCHEMA);
            }
            if (StringUtils.isEmpty((String)dbSchema) && mpDbType.getDb().equalsIgnoreCase(DbType.SQL_SERVER.getDb())) {
                dbSchema = "dbo";
            }
            String url = ConnUtil.getUrl((DbSourceOrDbLink)linkEntity);
            DataSourceConfig dsc = new DataSourceConfig.Builder(url, userName, password).schema(dbSchema).keyWordsHandler((IKeyWordsHandler)new MySqlKeyWordsHandler()).build();
            return dsc;
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    static class MyPostgreSqlQuery
    extends PostgreSqlQuery {
        MyPostgreSqlQuery() {
        }

        public String tableFieldsSql() {
            return "SELECT A.attname AS name,format_type (A.atttypid,A.atttypmod) AS type,col_description (A.attrelid,A.attnum) AS comment,\n(CASE WHEN (SELECT COUNT (*) FROM pg_constraint AS PC WHERE PC.conrelid = C.oid AND A.attnum = PC.conkey[1] AND PC.contype = 'p') > 0 THEN 'PRI' ELSE '' END) AS key \nFROM pg_class AS C,pg_attribute AS A WHERE A.attrelid='%s'::regclass AND A.attrelid= C.oid AND A.attnum> 0 AND NOT A.attisdropped ORDER  BY A.attnum";
        }
    }
}

