/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.listener.DIngStream;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.bean.WxCpDepartTreeNode;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.service.SynPushToThirdQyService;
import com.bringspring.system.external.service.WxCpCorpService;
import com.bringspring.system.external.util.WxCpCorpValidateUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.OraganizeListVO;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynQyWebChatUtil;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import me.chanjar.weixin.cp.api.WxCpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4f01\u4e1a\u5fae\u4fe1-\u4f01\u4e1a")
@RestController
@RequestMapping(value={"/api/external/corp/{corpId}/{agentId}"})
public class WxCpCorpController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WxCpCorpController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private DIngStream dIngStream;
    @Autowired
    WxCpConfiguration wxCpConfiguration;
    @Autowired
    WxCpCorpValidateUtil wxCpCorpValidateUtil;
    @Autowired
    private WxCpCorpService wxCpCorpService;
    @Autowired
    private SynPushToThirdQyService synPushToThirdQyService;

    @Operation(summary="\u4f01\u4e1a\u5fae\u4fe1\u3010\u4f01\u4e1a\u3011\u83b7\u53d6\u4f01\u4e1a\u90e8\u95e8\u5217\u8868")
    @GetMapping(value={"/department/deptList"})
    @DSTransactional
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public ActionResult corpDepartmentList(@PathVariable(value="corpId") String corpId, @PathVariable(value="agentId") Integer agentId) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            return ActionResult.fail((String)String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", corpId, agentId));
        }
        try {
            List departList = wxCpService.getDepartmentService().list(null);
            if (departList == null || departList.size() == 0) {
                return ActionResult.fail((String)"\u83b7\u53d6\u83b7\u53d6\u90e8\u95e8\u5217\u8868\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a");
            }
            Long parentid = 0L;
            WeComModel weComModel = this.wxCpConfiguration.getWeComModel(corpId);
            SynThirdInfoEntity parentThird = null;
            if (StringUtils.isNotEmpty((String)weComModel.getOrgParent()) && ObjectUtil.isNotEmpty((Object)(parentThird = this.synThirdInfoService.getInfoBySysObjId("1", "1", weComModel.getOrgParent()))) && StringUtils.isNotEmpty((String)parentThird.getThirdObjectId())) {
                parentid = Long.valueOf(parentThird.getThirdObjectId());
            }
            List treeList = JsonUtil.getJsonToList((Object)departList, WxCpDepartTreeNode.class);
            List<WxCpDepartTreeNode> wxCpDepartTreeNodes = this.wxCpCorpService.deptListToTree(treeList, parentid);
            this.wxCpCorpService.saveOrUpdateOrganizeList(wxCpDepartTreeNodes, corpId, parentThird);
            SynThirdTotal synTotal = this.synThirdInfoService.getCorpDataTypeSynTotal("1", "1", corpId);
            return ActionResult.success((Object)synTotal);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u7cfb\u7edf\u8fd0\u884c\u65f6\u5f02\u5e38\uff1a" + String.valueOf(e)));
        }
    }

    @Operation(summary="\u672c\u5730\u90e8\u95e8\u5217\u8868\u63a8\u9001\u4f01\u4e1a\u90e8\u95e8\u5217\u8868")
    @GetMapping(value={"/department/pushBatch"})
    @DSTransactional
    public ActionResult pushBatchDeptList(@PathVariable(value="corpId") String corpId, @PathVariable(value="agentId") Integer agentId) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        try {
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getListByCrop("1", "1", corpId);
            List<String> idList = synThirdInfoList.stream().map(SynThirdInfoEntity::getSystemObjectId).collect(Collectors.toList());
            List<OrganizeEntity> organizeList = this.organizeService.getListAll(idList, null);
            List organizeModelList = JsonUtil.getJsonToList(organizeList, OrganizeModel.class);
            List trees = TreeDotUtils.convertListToTreeDot((List)organizeModelList);
            List listVO = JsonUtil.getJsonToList((Object)trees, OraganizeListVO.class);
            ArrayList<OrganizeEntity> listByOrder = new ArrayList<OrganizeEntity>();
            for (OraganizeListVO organizeVo : listVO) {
                OrganizeEntity entity = organizeList.stream().filter(t -> t.getId().equals(organizeVo.getId())).findFirst().orElse(null);
                listByOrder.add(entity);
                SynQyWebChatUtil.getOrganizeTreeToList(organizeVo, organizeList, listByOrder);
            }
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (organizeList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                this.synPushToThirdQyService.deleteDepartmentSysToQy(userInfo, true, synThirdInfoEntity.getSystemObjectId(), null);
            }
            for (OrganizeEntity organizeEntity : listByOrder) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(organizeEntity.getId())).count() > 0L) {
                    this.synPushToThirdQyService.updateDepartmentSysToQy(userInfo, true, organizeEntity, null);
                    continue;
                }
                this.synPushToThirdQyService.createDepartmentSysToQy(userInfo, true, organizeEntity, null);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synTotal = this.synThirdInfoService.getCorpDataTypeSynTotal("1", "1", corpId);
        return ActionResult.success((Object)synTotal);
    }

    @Operation(summary="\u4f01\u4e1a\u5fae\u4fe1\u3010\u4f01\u4e1a\u3011\u83b7\u53d6\u4f01\u4e1a\u90e8\u95e8\u6210\u5458\u8be6\u60c5")
    @GetMapping(value={"/user/userList"})
    @DSTransactional
    @CacheEvict(value={"UserCache"}, allEntries=true)
    public ActionResult corpUserList(@PathVariable(value="corpId") String corpId, @PathVariable(value="agentId") Integer agentId) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            return ActionResult.fail((String)String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", corpId, agentId));
        }
        try {
            Long departId = 1L;
            boolean fetchChild = true;
            Integer status = 0;
            List users = wxCpService.getUserService().listByDepartment(departId, Boolean.valueOf(fetchChild), status);
            if (users == null || users.size() == 0) {
                return ActionResult.fail((String)"\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55\u5458\u5de5\u4fe1\u606f\u4e3a\u7a7a");
            }
            this.wxCpCorpService.saveOrUpdateUserList(users, wxCpService);
            SynThirdTotal synTotal = this.synThirdInfoService.getCorpDataTypeSynTotal("1", "2", corpId);
            return ActionResult.success((Object)synTotal);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u7cfb\u7edf\u8fd0\u884c\u65f6\u5f02\u5e38\uff1a" + String.valueOf(e)));
        }
    }

    @Operation(summary="\u672c\u5730\u7528\u6237\u5217\u8868\u63a8\u9001\u4f01\u4e1a\u90e8\u95e8\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/user/pushBatch"})
    public ActionResult pushBatchUserList(@PathVariable(value="corpId") String corpId, @PathVariable(value="agentId") Integer agentId) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        try {
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getListByCrop("1", "2", corpId, false, false);
            List<String> idList = synThirdInfoList.stream().map(SynThirdInfoEntity::getSystemObjectId).collect(Collectors.toList());
            List<UserEntity> userList = this.userService.getUserByIds(idList);
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (userList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                this.synPushToThirdQyService.deleteUserSysToQy(userInfo, true, synThirdInfoEntity.getSystemObjectId(), null);
            }
            List<OrganizeEntity> list = this.organizeService.getList();
            for (UserEntity userEntity : userList) {
                OrganizeEntity info = this.organizeService.getInfo(userEntity.getOrganizeId());
                if (synThirdInfoList.stream().filter(t -> userEntity.getId().equals(t.getSystemObjectId())).count() > 0L) {
                    this.synPushToThirdQyService.updateUserSysToQy(userInfo, true, userEntity, null);
                    continue;
                }
                this.synPushToThirdQyService.createUserSysToQy(userInfo, true, userEntity, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)e.getMessage());
        }
        SynThirdTotal synTotal = this.synThirdInfoService.getCorpDataTypeSynTotal("1", "2", corpId);
        return ActionResult.success((Object)synTotal);
    }

    @Operation(summary="\u83b7\u53d6\u7b2c\u4e09\u65b9\u4f01\u4e1a\u7684\u7ec4\u7ec7\u4e0e\u7528\u6237\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f")
    @GetMapping(value={"/getWxCpSynThirdInfoTotal"})
    public ActionResult getWxCpSynThirdInfoTotal(@PathVariable(value="corpId") String corpId, @PathVariable(value="agentId") Integer agentId) {
        return ActionResult.success(this.synThirdInfoService.getCorpSynTotal("1", corpId, false));
    }
}

