/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.mapper.SynThirdInfoMapper;
import com.bringspring.system.message.model.message.SynThirdInfoCrForm;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SynThirdInfoServiceImpl
extends ServiceImpl<SynThirdInfoMapper, SynThirdInfoEntity>
implements SynThirdInfoService {
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserService userService;

    @Override
    public List<SynThirdInfoEntity> getList(SynThirdInfoCrForm synThirdInfoCrForm) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotNull((Object)synThirdInfoCrForm.getThirdtype())) {
            queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)synThirdInfoCrForm.getThirdtype()));
        }
        if (StringUtils.isNotNull((Object)synThirdInfoCrForm.getDatatype())) {
            queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)synThirdInfoCrForm.getDatatype()));
        }
        if (StringUtils.isNotNull((Object)synThirdInfoCrForm.getSysObjId())) {
            queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getSystemObjectId, (Object)synThirdInfoCrForm.getSysObjId()));
        }
        if (StringUtils.isNotNull((Object)synThirdInfoCrForm.getThirdObjId())) {
            queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdObjectId, (Object)synThirdInfoCrForm.getThirdObjId()));
        }
        if (StringUtils.isNotNull((Object)synThirdInfoCrForm.getSynstate())) {
            queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getSynState, (Object)synThirdInfoCrForm.getSynstate()));
        }
        queryWrapper.lambda().orderByDesc(SynThirdInfoEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getList(String thirdType, String dataType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)Integer.valueOf(thirdType)));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)Integer.valueOf(dataType)));
        queryWrapper.lambda().orderByDesc(SynThirdInfoEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getListByCrop(String thirdType, String dataType, String crop) {
        return this.getListByCrop(thirdType, dataType, crop, true);
    }

    @Override
    public List<SynThirdInfoEntity> getListByCrop(String thirdType, String dataType, String crop, boolean isOkBySynState) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)Integer.valueOf(thirdType)));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)Integer.valueOf(dataType)));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getCropId, (Object)crop));
        if (!isOkBySynState) {
            queryWrapper.lambda().and(t -> t.ne(SynThirdInfoEntity::getSynState, (Object)SynThirdConsts.SYN_STATE_OK));
        }
        queryWrapper.lambda().orderByDesc(SynThirdInfoEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getListByCrop(String thirdType, String dataType, String crop, boolean isOkBySynState, boolean isLinkedCorp) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)Integer.valueOf(thirdType)));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)Integer.valueOf(dataType)));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getCropId, (Object)crop));
        if (!isOkBySynState) {
            queryWrapper.lambda().and(t -> t.ne(SynThirdInfoEntity::getSynState, (Object)SynThirdConsts.SYN_STATE_OK));
        }
        if (isLinkedCorp) {
            queryWrapper.lambda().and(t -> t.like(SynThirdInfoEntity::getThirdObjectId, (Object)"%/%"));
        } else {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.notLike(SynThirdInfoEntity::getThirdObjectId, (Object)"%/%")).or()).isNull(SynThirdInfoEntity::getThirdObjectId)).or()).eq(SynThirdInfoEntity::getThirdObjectId, (Object)""));
        }
        queryWrapper.lambda().orderByDesc(SynThirdInfoEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getListByObjId(Integer thirdType, List<String> objId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SynThirdInfoEntity::getThirdType, (Object)thirdType)).in(SynThirdInfoEntity::getSystemObjectId, objId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public SynThirdInfoEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SynThirdInfoEntity::getId, (Object)id);
        return (SynThirdInfoEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(SynThirdInfoEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, SynThirdInfoEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(SynThirdInfoEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public SynThirdInfoEntity getInfoBySysObjId(String thirdType, String dataType, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)thirdType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)dataType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getSystemObjectId, (Object)id));
        return (SynThirdInfoEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getInfoBySysObjIds(String thirdType, String dataType, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)thirdType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)dataType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getSystemObjectId, (Object)id));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getInfoBySysObjIds(String thirdType, String dataType, String id, Boolean isLinkedCorp) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)thirdType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)dataType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getSystemObjectId, (Object)id));
        if (isLinkedCorp.booleanValue()) {
            queryWrapper.lambda().and(t -> t.like(SynThirdInfoEntity::getThirdObjectId, (Object)"%/%"));
        } else {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.notLike(SynThirdInfoEntity::getThirdObjectId, (Object)"%/%")).or()).isNull(SynThirdInfoEntity::getThirdObjectId)).or()).eq(SynThirdInfoEntity::getThirdObjectId, (Object)""));
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getThirdInfoList(String thirdType, String dataType, String corpId, Set<String> userSet) {
        return this.getThirdInfoList(thirdType, dataType, corpId, userSet, null);
    }

    @Override
    public List<SynThirdInfoEntity> getThirdInfoList(String thirdType, String dataType, String corpId, Set<String> userSet, Boolean isLinkedCorp) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)thirdType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)dataType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getCropId, (Object)corpId));
        queryWrapper.lambda().and(t -> t.in(SynThirdInfoEntity::getSystemObjectId, (Collection)userSet));
        if (isLinkedCorp != null && isLinkedCorp.booleanValue()) {
            queryWrapper.lambda().and(t -> t.like(SynThirdInfoEntity::getThirdObjectId, (Object)"%/%"));
        } else {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.notLike(SynThirdInfoEntity::getThirdObjectId, (Object)"%/%")).or()).isNull(SynThirdInfoEntity::getThirdObjectId)).or()).eq(SynThirdInfoEntity::getThirdObjectId, (Object)""));
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public SynThirdInfoEntity getInfoByThirdObjId(String thirdType, String dataType, String thirdObjid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)thirdType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)dataType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdObjectId, (Object)thirdObjid));
        return (SynThirdInfoEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public SynThirdInfoEntity getInfoByThirdObjId(String thirdType, String dataType, String thirdObjid, String corpId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getCropId, (Object)corpId));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)thirdType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)dataType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdObjectId, (Object)thirdObjid));
        return (SynThirdInfoEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getInfoByThirdObjIds(String thirdType, String dataType, String thirdObjid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)thirdType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)dataType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdObjectId, (Object)thirdObjid));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SynThirdInfoEntity> getListByThirdObjIds(String thirdType, String dataType, String corpId, List<String> thirdObjIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getThirdType, (Object)thirdType));
        queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getDataType, (Object)dataType));
        if (StringUtils.isNotEmpty((String)corpId)) {
            queryWrapper.lambda().and(t -> t.eq(SynThirdInfoEntity::getCropId, (Object)corpId));
        }
        if (CollectionUtil.isNotEmpty(thirdObjIds)) {
            queryWrapper.lambda().and(t -> t.in(SynThirdInfoEntity::getThirdObjectId, (Collection)thirdObjIds));
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public SynThirdTotal getSynTotal(String thirdType, String dataType) {
        String synType = dataType.equals("1") ? "\u7ec4\u7ec7" : "\u7528\u6237";
        Integer recordTotal = 0;
        Long synSuccessCount = 0L;
        Long synFailCount = 0L;
        Long unSynCount = 0L;
        Date synDate = null;
        List<SynThirdInfoEntity> synList = this.getList(thirdType, dataType);
        if (synList != null && synList.size() > 0) {
            synSuccessCount = synList.stream().filter(t -> t.getSynState().equals(SynThirdConsts.SYN_STATE_OK)).count();
            synFailCount = synList.stream().filter(t -> t.getSynState().equals(SynThirdConsts.SYN_STATE_FAIL)).count();
            unSynCount = synList.stream().filter(t -> t.getSynState().equals(SynThirdConsts.SYN_STATE_NO)).count();
            if ((synList = synList.stream().filter(x -> x.getLastModifyTime() != null).collect(Collectors.toList())).size() > 0) {
                Optional<SynThirdInfoEntity> max = synList.stream().max(Comparator.comparing(SynThirdInfoEntity::getLastModifyTime));
                synDate = max.get().getLastModifyTime();
            } else {
                synDate = null;
            }
        }
        recordTotal = dataType.equals("1") ? Integer.valueOf(this.organizeService.getList().size()) : Integer.valueOf(this.userService.getList().size());
        SynThirdTotal synThirdTotal = new SynThirdTotal();
        synThirdTotal.setSynType(synType);
        synThirdTotal.setRecordTotal(recordTotal);
        synThirdTotal.setSynSuccessCount(synSuccessCount);
        synThirdTotal.setSynFailCount(synFailCount);
        synThirdTotal.setUnSynCount(unSynCount);
        synThirdTotal.setSynDate(synDate);
        return synThirdTotal;
    }

    @Override
    public List<SynThirdTotal> getCorpSynTotal(String thirdType, String corpId) {
        return this.getCorpSynTotal(thirdType, corpId, false);
    }

    @Override
    public List<SynThirdTotal> getCorpSynTotal(String thirdType, String corpId, boolean isLinkedCorp) {
        ArrayList<SynThirdTotal> synTotalList = new ArrayList<SynThirdTotal>();
        SynThirdTotal synThirdTotal = new SynThirdTotal();
        synThirdTotal.setSynType("\u7ec4\u7ec7");
        List<SynThirdInfoEntity> synList = this.countSynRestState(thirdType, "1", corpId, synThirdTotal, isLinkedCorp);
        String companyid = null;
        List<OrganizeEntity> allCompanyList = this.organizeService.getAllCompanyList(null);
        if (CollectionUtil.isNotEmpty(allCompanyList)) {
            for (OrganizeEntity dept : allCompanyList) {
                if (!"-1".equals(dept.getParentId()) || synList.stream().filter(t -> t.getSystemObjectId().equals(dept.getId())).count() <= 0L) continue;
                companyid = dept.getId();
                break;
            }
        }
        if (StringUtils.isNotEmpty(companyid)) {
            List<OrganizeEntity> orgList = this.organizeService.getListLikeOrgIdTree(companyid);
            synThirdTotal.setRecordTotal(orgList.size());
            synTotalList.add(synThirdTotal);
            SynThirdTotal synThirdTotalU = new SynThirdTotal();
            synThirdTotalU.setSynType("\u7528\u6237");
            this.countSynRestState(thirdType, "2", corpId, synThirdTotalU, isLinkedCorp);
            List<String> orgIds = orgList.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
            synThirdTotalU.setRecordTotal(this.userService.getUserByOrgIds(orgIds).size());
            synTotalList.add(synThirdTotalU);
        }
        return synTotalList;
    }

    @Override
    public SynThirdTotal getCorpDataTypeSynTotal(String thirdType, String dataType, String corpId) {
        return this.getCorpDataTypeSynTotal(thirdType, dataType, corpId, false);
    }

    @Override
    public SynThirdTotal getCorpDataTypeSynTotal(String thirdType, String dataType, String corpId, boolean isLinkedCorp) {
        String synType = dataType.equals("1") ? "\u7ec4\u7ec7" : "\u7528\u6237";
        SynThirdTotal synThirdTotal = new SynThirdTotal();
        synThirdTotal.setSynType(synType);
        List<SynThirdInfoEntity> deptSynList = dataType.equals("1") ? this.countSynRestState(thirdType, "1", corpId, synThirdTotal, isLinkedCorp) : this.getListByCrop(thirdType, "1", corpId);
        String companyid = null;
        List<OrganizeEntity> allCompanyList = this.organizeService.getAllCompanyList(null);
        if (CollectionUtil.isNotEmpty(allCompanyList)) {
            for (OrganizeEntity dept : allCompanyList) {
                if (!"-1".equals(dept.getParentId()) || deptSynList.stream().filter(t -> t.getSystemObjectId().equals(dept.getId())).count() <= 0L) continue;
                companyid = dept.getId();
                break;
            }
        }
        if (StringUtils.isNotEmpty(companyid)) {
            List<OrganizeEntity> orgList = this.organizeService.getListLikeOrgIdTree(companyid);
            if (dataType.equals("1")) {
                synThirdTotal.setRecordTotal(orgList.size());
            } else {
                this.countSynRestState(thirdType, "2", corpId, synThirdTotal, isLinkedCorp);
                List<String> orgIds = orgList.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
                synThirdTotal.setRecordTotal(this.userService.getUserByOrgIds(orgIds).size());
            }
        }
        return synThirdTotal;
    }

    public List<SynThirdInfoEntity> countSynRestState(String thirdType, String dataType, String corpId, SynThirdTotal synThirdTotal, boolean isLinkedCorp) {
        Long synSuccessCount = 0L;
        Long synFailCount = 0L;
        Long unSynCount = 0L;
        Date synDate = null;
        List<SynThirdInfoEntity> synList = this.getListByCrop(thirdType, dataType, corpId, true, isLinkedCorp);
        if (synList != null && synList.size() > 0) {
            synSuccessCount = synList.stream().filter(t -> t.getSynState().equals(SynThirdConsts.SYN_STATE_OK)).count();
            synFailCount = synList.stream().filter(t -> t.getSynState().equals(SynThirdConsts.SYN_STATE_FAIL)).count();
            unSynCount = synList.stream().filter(t -> t.getSynState().equals(SynThirdConsts.SYN_STATE_NO)).count();
            if ((synList = synList.stream().filter(x -> x.getLastModifyTime() != null).collect(Collectors.toList())).size() > 0) {
                Optional<SynThirdInfoEntity> max = synList.stream().max(Comparator.comparing(SynThirdInfoEntity::getLastModifyTime));
                synDate = max.get().getLastModifyTime();
            } else {
                synDate = null;
            }
        }
        synThirdTotal.setSynSuccessCount(synSuccessCount);
        synThirdTotal.setSynFailCount(synFailCount);
        synThirdTotal.setUnSynCount(unSynCount);
        synThirdTotal.setSynDate(synDate);
        return synList;
    }
}

