/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.message.MyEmailModel;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageSender;
import com.bringspring.system.msgcenter.util.BlacklistUtil;
import com.bringspring.system.msgcenter.util.EmailUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MsgToEmailService
extends AbstractMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgToEmailService.class);

    @Override
    protected int getBatchSize() {
        return 1000;
    }

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.MAIL_MSG;
    }

    @Override
    protected void validateParameters(SendMessageContext context) {
        this.validateTemplate(context);
        this.validateAccount(context);
    }

    @Override
    protected void doSend(SendMessageContext context) {
        if (CollectionUtil.isNotEmpty(context.getValidList())) {
            List<McTaskMsgReceiveEntity> receiveList = context.getValidList();
            McMsgAccountEntity account = context.getMsgAccount();
            HashMap<String, String> objModel = new HashMap<String, String>();
            objModel.put("emailSmtpHost", account.getSmtpServer());
            objModel.put("emailSmtpPort", account.getSmtpPort().toString());
            objModel.put("emailSenderName", account.getAddressorName());
            objModel.put("emailAccount", account.getSmtpUser());
            objModel.put("emailPassword", account.getSmtpPassword());
            objModel.put("emailSsl", account.getSslLink().equals("1") ? "true" : "false");
            McTaskMsgContentEntity taskMsgContent = context.getTaskMsgContent();
            List emailList = receiveList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
            String toUserMail = StringUtils.join(emailList, (String)",");
            MyEmailModel emailModel = (MyEmailModel)JsonUtil.getJsonToBean(objModel, MyEmailModel.class);
            emailModel.setEmailTitle(taskMsgContent.getTitle());
            emailModel.setEmailContent(taskMsgContent.getContent());
            emailModel.setEmailToUsers(toUserMail);
            ArrayList<McTaskMsgReceiveEntity> validList = new ArrayList<McTaskMsgReceiveEntity>();
            ArrayList<McTaskMsgReceiveEntity> invalidList = new ArrayList<McTaskMsgReceiveEntity>();
            try {
                JSONObject retJson = EmailUtil.sendMail(emailModel);
                if (!retJson.getBoolean("code").booleanValue()) {
                    invalidList.addAll(receiveList);
                    invalidList.stream().forEach(e -> {
                        e.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                        e.setDescription(retJson.getString("error"));
                    });
                } else {
                    validList.addAll(receiveList);
                    receiveList.stream().forEach(e -> {
                        e.setEnabledMark(EnabledMarkEnum.SUCCESS.getCode());
                        e.setDescription(retJson.getString("error"));
                    });
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                invalidList.addAll(receiveList);
                invalidList.stream().forEach(r -> {
                    r.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                    r.setDescription(e2.getMessage());
                });
            }
            context.getInvalidList().addAll(invalidList);
            context.setValidList(validList);
        }
    }

    @Override
    protected void sendBatchNonSystemUser(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u7535\u5b50\u90ae\u4ef6\u6d88\u606f\u3010\u975e\u7cfb\u7edf\u7528\u6237\u3011\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        this.sendBatch(isAgain, sendTemplate, taskMsgContent, receiveListS, currentUserInfo);
    }

    @Override
    protected void sendBatch(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u7535\u5b50\u90ae\u4ef6\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        if (ObjectUtil.isNotNull((Object)templateInfo) && ObjectUtil.isNotNull((Object)msgAccount)) {
            List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
            if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
                List<McTaskMsgReceiveEntity> emailNullList = receiveList.stream().filter(r -> StringUtils.isEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List<McTaskMsgReceiveEntity> emailNotNullList = receiveList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List emailList = emailNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(emailList)) {
                    HashMap<String, String> objModel = new HashMap<String, String>();
                    objModel.put("emailSmtpHost", msgAccount.getSmtpServer());
                    objModel.put("emailSmtpPort", msgAccount.getSmtpPort().toString());
                    objModel.put("emailSenderName", msgAccount.getAddressorName());
                    objModel.put("emailAccount", msgAccount.getSmtpUser());
                    objModel.put("emailPassword", msgAccount.getSmtpPassword());
                    objModel.put("emailSsl", msgAccount.getSslLink().equals("1") ? "true" : "false");
                    MyEmailModel emailModel = (MyEmailModel)JsonUtil.getJsonToBean(objModel, MyEmailModel.class);
                    emailModel.setEmailTitle(taskMsgContent.getTitle());
                    emailModel.setEmailContent(taskMsgContent.getContent());
                    String toUserMail = StringUtils.join(emailList, (String)",");
                    emailModel.setEmailToUsers(toUserMail);
                    JSONObject retJson = EmailUtil.sendMail(emailModel);
                    if (!retJson.getBoolean("code").booleanValue()) {
                        String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + retJson.getString("error");
                        this.mcTaskMsgReceiveService.updateByList(isAgain, emailNotNullList, 2, errMsg, currentUserInfo);
                    } else {
                        String errMsg = (isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a") + retJson.getString("error");
                        this.mcTaskMsgReceiveService.updateByList(isAgain, emailNotNullList, 1, errMsg, currentUserInfo);
                    }
                }
                if (CollectionUtil.isNotEmpty(emailNullList)) {
                    String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0\u6709\u6548\u7535\u5b50\u90ae\u7bb1";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, emailNullList, 2, errMsg, currentUserInfo);
                }
            }
            if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist, currentUserInfo);
            }
        }
    }
}

