/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.ModuleButtonEntity;
import com.bringspring.system.base.entity.ModuleColumnEntity;
import com.bringspring.system.base.entity.ModuleDataAuthorizeSchemeEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.entity.ModuleFormEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ModuleButtonService;
import com.bringspring.system.base.service.ModuleColumnService;
import com.bringspring.system.base.service.ModuleDataAuthorizeSchemeService;
import com.bringspring.system.base.service.ModuleFormService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.ColumnsPurviewEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeDataModel;
import com.bringspring.system.permission.model.authorize.AuthorizeDataReturnModel;
import com.bringspring.system.permission.model.authorize.AuthorizeDataReturnVO;
import com.bringspring.system.permission.model.authorize.AuthorizeDataUpForm;
import com.bringspring.system.permission.model.authorize.AuthorizeDataVO;
import com.bringspring.system.permission.model.authorize.AuthorizeItemObjIdsVO;
import com.bringspring.system.permission.model.authorize.AuthorizeVO;
import com.bringspring.system.permission.model.authorize.DataValuesQuery;
import com.bringspring.system.permission.model.authorize.SaveAuthForm;
import com.bringspring.system.permission.model.authorize.SaveBatchForm;
import com.bringspring.system.permission.model.columnspurview.ColumnsPurviewUpForm;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.ColumnsPurviewService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u64cd\u4f5c\u6743\u9650", description="Authorize")
@RestController
@RequestMapping(value={"/api/permission/Authority"})
public class AuthorizeController {
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ModuleButtonService buttonService;
    @Autowired
    private ModuleColumnService columnService;
    @Autowired
    private ModuleFormService formService;
    @Autowired
    private ModuleDataAuthorizeSchemeService schemeService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private ColumnsPurviewService columnsPurviewService;

    @Operation(summary="\u83b7\u53d6\u6743\u9650\u6570\u636e")
    @GetMapping(value={"/{objectId}"})
    public ActionResult<AuthorizeDataVO> data(@PathVariable(value="objectId") String objectId) {
        List<ModuleEntity> moduleList = this.moduleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<ModuleButtonEntity> moduleButtonList = this.buttonService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<ModuleColumnEntity> moduleColumnList = this.columnService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<ModuleFormEntity> moduleFormList = this.formService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<ModuleDataAuthorizeSchemeEntity> moduleDataSchemeList = this.schemeService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(true);
        List authorizeList = this.authorizeService.list((Wrapper)new QueryWrapper().lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId));
        AuthorizeDataVO vo = new AuthorizeDataVO();
        vo.setModule(this.authorizeService.module(moduleList, authorizeList, authorizeModel));
        vo.setButton(this.authorizeService.moduleButton(moduleList, moduleButtonList, authorizeList, authorizeModel));
        vo.setColumn(this.authorizeService.moduleColumn(moduleList, moduleColumnList, authorizeList, authorizeModel));
        vo.setForm(this.authorizeService.moduleForm(moduleList, moduleFormList, authorizeList, authorizeModel));
        vo.setResource(this.authorizeService.resourceData(moduleList, moduleDataSchemeList, authorizeList, authorizeModel));
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u5c97\u4f4d/\u89d2\u8272/\u7528\u6237\u6743\u9650\u6811\u5f62\u7ed3\u6784")
    @GetMapping(value={"/Data/{objectId}"})
    public ActionResult<AuthorizeDataVO> getData(@PathVariable(value="objectId") String objectId) {
        List<ModuleEntity> moduleList = this.moduleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<ModuleButtonEntity> moduleButtonList = this.buttonService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<ModuleColumnEntity> moduleColumnList = this.columnService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<ModuleFormEntity> moduleFormList = this.formService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<ModuleDataAuthorizeSchemeEntity> moduleDataSchemeList = this.schemeService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(true);
        List list = this.authorizeService.list((Wrapper)new QueryWrapper().lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId));
        AuthorizeDataVO vo = new AuthorizeDataVO();
        vo.setModule(this.authorizeService.module(moduleList, list, authorizeModel));
        vo.setButton(this.authorizeService.moduleButton(moduleList, moduleButtonList, list, authorizeModel));
        vo.setColumn(this.authorizeService.moduleColumn(moduleList, moduleColumnList, list, authorizeModel));
        vo.setForm(this.authorizeService.moduleForm(moduleList, moduleFormList, list, authorizeModel));
        vo.setResource(this.authorizeService.resourceData(moduleList, moduleDataSchemeList, list, authorizeModel));
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u5c97\u4f4d/\u89d2\u8272/\u7528\u6237\u6743\u9650\u6811\u5f62\u7ed3\u6784")
    @PostMapping(value={"/Data/{objectId}/Values"})
    public ActionResult<AuthorizeDataReturnVO> getValuesData(@PathVariable(value="objectId") String objectId, @RequestBody DataValuesQuery dataValuesQuery) {
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(true);
        List list = this.authorizeService.list((Wrapper)new QueryWrapper().lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId));
        if (!StringUtils.isEmpty((String)dataValuesQuery.getType())) {
            AuthorizeDataReturnVO authorizeDataReturnVO = this.authorizeService.getAuthorizeDataReturnVO(authorizeModel, list, dataValuesQuery, objectId);
            return ActionResult.success((Object)authorizeDataReturnVO);
        }
        return ActionResult.fail((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Operation(summary="\u6839\u636e\u89d2\u8272id\u83b7\u53d6\u5c97\u4f4d/\u89d2\u8272/\u7528\u6237\u6743\u9650\u6811\u5f62\u7ed3\u6784")
    @PostMapping(value={"/RoleData/{objectId}/Values"})
    public ActionResult<AuthorizeDataReturnVO> getRoleValuesData(@PathVariable(value="objectId") String objectId, @RequestBody DataValuesQuery dataValuesQuery) throws Exception {
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorizeByRoleId(objectId);
        List list = this.authorizeService.list((Wrapper)new QueryWrapper().lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId));
        if (!StringUtils.isEmpty((String)dataValuesQuery.getType())) {
            AuthorizeDataReturnVO authorizeDataReturnVO = this.authorizeService.getAuthorizeDataReturnVO(authorizeModel, list, dataValuesQuery, objectId);
            return ActionResult.success((Object)authorizeDataReturnVO);
        }
        return ActionResult.fail((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Operation(summary="\u83b7\u53d6\u5bf9\u8c61\u6743\u9650\u6570\u636e")
    @GetMapping(value={"/DataObject"})
    public ActionResult dataObject() {
        List<RoleEntity> roleData = this.roleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<OrganizeEntity> organizeData = this.organizeService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<PositionEntity> positionData = this.positionService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        List<UserEntity> userData = this.userService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
        HashMap<String, AuthorizeDataReturnVO> map = new HashMap<String, AuthorizeDataReturnVO>(16);
        map.put("role", this.roleTree(roleData));
        map.put("position", this.positionTree(organizeData, positionData));
        map.put("user", this.userTree(organizeData, userData));
        return ActionResult.success(map);
    }

    @Operation(summary="\u83b7\u53d6\u529f\u80fd\u6743\u9650\u6570\u636e")
    @GetMapping(value={"/Model/{itemId}/{objectType}"})
    public ActionResult getObjectAuth(@PathVariable(value="itemId") String itemId, @PathVariable(value="objectType") String objectType) {
        List<AuthorizeEntity> authorizeList = this.authorizeService.getListByObjectAndItem(itemId, objectType);
        List<String> ids = authorizeList.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        AuthorizeItemObjIdsVO vo = new AuthorizeItemObjIdsVO();
        vo.setIds(ids);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u8bbe\u7f6e/\u66f4\u65b0\u529f\u80fd\u6743\u9650")
    @PutMapping(value={"/Model/{itemId}"})
    @HandleLog(moduleName="\u6743\u9650\u7ba1\u7406", requestMethod="\u8bbe\u7f6e/\u66f4\u65b0\u529f\u80fd\u6743\u9650")
    public ActionResult save(@PathVariable(value="itemId") String itemId, @RequestBody SaveAuthForm saveAuthForm) {
        this.authorizeService.saveAuth(itemId, saveAuthForm);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @Operation(summary="\u4fdd\u5b58\u6743\u9650")
    @PutMapping(value={"/Data/{objectId}"})
    @HandleLog(moduleName="\u6743\u9650\u7ba1\u7406", requestMethod="\u4fdd\u5b58\u6743\u9650")
    public ActionResult save(@PathVariable(value="objectId") String objectId, @RequestBody AuthorizeDataUpForm authorizeDataUpForm) {
        this.authorizeService.save(objectId, authorizeDataUpForm);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @Operation(summary="\u6279\u91cf\u4fdd\u5b58\u6743\u9650")
    @PostMapping(value={"/Data/Batch"})
    @HandleLog(moduleName="\u6743\u9650\u7ba1\u7406", requestMethod="\u6279\u91cf\u4fdd\u5b58\u6743\u9650")
    public ActionResult saveBatch(@RequestBody SaveBatchForm saveBatchForm) {
        this.authorizeService.saveBatch(saveBatchForm, true);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @Operation(summary="\u83b7\u53d6\u6a21\u5757\u5217\u8868\u5c55\u793a\u5b57\u6bb5")
    @GetMapping(value={"/GetColumnsByModuleId/{moduleId}"})
    public ActionResult getColumnsByModuleId(@PathVariable(value="moduleId") String moduleId) {
        ColumnsPurviewEntity entity = this.columnsPurviewService.getInfo(moduleId);
        List jsonToListMap = null;
        if (entity != null) {
            jsonToListMap = JsonUtil.getJsonToListMap((String)entity.getFieldList());
        }
        return ActionResult.success((Object)(jsonToListMap != null ? jsonToListMap : new ArrayList(16)));
    }

    @Operation(summary="\u914d\u7f6e\u6a21\u5757\u5217\u8868\u5c55\u793a\u5b57\u6bb5")
    @PutMapping(value={"/SetColumnsByModuleId"})
    public ActionResult setColumnsByModuleId(@RequestBody ColumnsPurviewUpForm columnsPurviewUpForm) {
        ColumnsPurviewEntity entity = (ColumnsPurviewEntity)JsonUtil.getJsonToBean((Object)columnsPurviewUpForm, ColumnsPurviewEntity.class);
        this.columnsPurviewService.update(columnsPurviewUpForm.getModuleId(), entity);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    AuthorizeDataReturnVO roleTree(List<RoleEntity> data) {
        ArrayList<AuthorizeDataModel> treeList = new ArrayList<AuthorizeDataModel>();
        List<DictionaryDataEntity> typeData = this.dictionaryDataService.getList("4501f6f26a384757bce12d4c4b03342c");
        for (DictionaryDataEntity dictionaryDataEntity : typeData) {
            AuthorizeDataModel dictionary = new AuthorizeDataModel();
            dictionary.setId(dictionaryDataEntity.getEnCode());
            dictionary.setFullName(dictionaryDataEntity.getFullName());
            dictionary.setShowcheck(false);
            dictionary.setParentId("-1");
            treeList.add(dictionary);
        }
        for (RoleEntity roleEntity : data) {
            AuthorizeDataModel role = new AuthorizeDataModel();
            role.setId(roleEntity.getId());
            role.setFullName(roleEntity.getFullName());
            role.setParentId(roleEntity.getType());
            role.setShowcheck(true);
            role.setIcon("fa fa-umbrella");
            treeList.add(role);
        }
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setList(JsonUtil.getJsonToList((Object)TreeDotUtils.convertListToTreeDot(treeList), AuthorizeDataReturnModel.class));
        return vo;
    }

    AuthorizeDataReturnVO positionTree(List<OrganizeEntity> organizeData, List<PositionEntity> positionData) {
        ArrayList<AuthorizeDataModel> treeList = new ArrayList<AuthorizeDataModel>();
        for (OrganizeEntity organizeEntity : organizeData) {
            AuthorizeDataModel organize = new AuthorizeDataModel();
            organize.setId(organizeEntity.getId());
            organize.setShowcheck(false);
            organize.setFullName(organizeEntity.getFullName());
            organize.setParentId(organizeEntity.getParentId());
            treeList.add(organize);
        }
        for (PositionEntity positionEntity : positionData) {
            AuthorizeDataModel position = new AuthorizeDataModel();
            position.setId(positionEntity.getId());
            position.setFullName(positionEntity.getFullName());
            position.setTitle(positionEntity.getEnCode());
            position.setParentId(positionEntity.getOrganizeId());
            position.setShowcheck(true);
            position.setIcon("fa fa-briefcase");
            treeList.add(position);
        }
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setList(JsonUtil.getJsonToList((Object)TreeDotUtils.convertListToTreeDot(treeList), AuthorizeDataReturnModel.class));
        return vo;
    }

    private AuthorizeDataReturnVO userTree(List<OrganizeEntity> organizeData, List<UserEntity> userData) {
        ArrayList<AuthorizeDataModel> treeList = new ArrayList<AuthorizeDataModel>();
        for (OrganizeEntity organizeEntity : organizeData) {
            AuthorizeDataModel organize = new AuthorizeDataModel();
            organize.setId(organizeEntity.getId());
            organize.setShowcheck(false);
            organize.setFullName(organizeEntity.getFullName());
            organize.setParentId(organizeEntity.getParentId());
            treeList.add(organize);
        }
        for (UserEntity userEntity : userData) {
            AuthorizeDataModel user = new AuthorizeDataModel();
            user.setId(userEntity.getId());
            user.setFullName(userEntity.getRealName());
            user.setParentId(userEntity.getOrganizeId());
            user.setShowcheck(true);
            user.setIcon("fa fa-user");
            treeList.add(user);
        }
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setList(JsonUtil.getJsonToList((Object)TreeDotUtils.convertListToTreeDot(treeList), AuthorizeDataReturnModel.class));
        return vo;
    }

    @Operation(summary="\u83b7\u53d6\u8868\u5355\u6761\u4ef6\u5185\u5bb9\u3001\u6761\u4ef6\u7b26\u53f7\u9009\u9879")
    @GetMapping(value={"/getDataAuthorizeFormSelect"})
    public ActionResult getDataAuthorizeFormSelect() {
        Map<String, List<Map<String, Object>>> dataAuthorizeForm = this.authorizeService.getDataAuthorizeForm();
        return ActionResult.success(dataAuthorizeForm);
    }
}

