/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.model.user.mod.RangeElementModel;
import com.bringspring.system.permission.model.user.vo.RangeElementSelectorVO;
import com.bringspring.system.permission.model.user.vo.UserSelectorVO;
import com.bringspring.system.permission.service.RangeService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9650\u5b9a\u4eba\u5458\u8303\u56f4", description="Range")
@RestController
@RequestMapping(value={"/api/permission/Range"})
public class RangeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RangeController.class);
    @Autowired
    private RangeService rangeService;

    @Operation(summary="\u83b7\u53d6\u8303\u56f4\u9650\u5b9a\u524d\u7aef\u7ec4\u4ef6\u6570\u636e")
    @PostMapping(value={"/RangeElement/Selector/{tab}"})
    public ActionResult<ListVO<RangeElementSelectorVO>> rangeElementSelector(@PathVariable(value="tab") String tab, @RequestBody Page page) {
        if (StringUtils.isEmpty((String)tab)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0ctab\u4e3a\u7a7a");
        }
        List<RangeElementSelectorVO> organizeUserList = this.rangeService.getOrganizeUserList(tab, page);
        ListVO vo = new ListVO();
        vo.setList(organizeUserList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u8303\u56f4\u9650\u5b9a\u524d\u7aef\u7ec4\u4ef6\u56de\u663e\u6570\u636e")
    @PostMapping(value={"/RangeElement/playback"})
    public ActionResult<ListVO<RangeElementSelectorVO>> rangeElementPlayback(@RequestBody List<RangeElementModel> selected) {
        if (CollectionUtil.isEmpty(selected)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0cselected\u4e3a\u7a7a");
        }
        List<RangeElementSelectorVO> organizeUserList = this.rangeService.getOrganizeUserList(selected);
        ListVO vo = new ListVO();
        vo.setList(organizeUserList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4e0b\u62c9\u6846\u5217\u8868(\u9650\u5b9a\u8303\u56f4\u7684)")
    @PostMapping(value={"/RangeElement/User/Selector"})
    public ActionResult<ListVO<UserSelectorVO>> rangeElementUserSelector(@RequestBody List<RangeElementModel> selected) {
        if (CollectionUtil.isEmpty(selected)) {
            return ActionResult.fail((String)"selected\u4e3a\u7a7a");
        }
        List<UserSelectorVO> rangeUserList = this.rangeService.getRangeUserList(selected);
        ListVO vo = new ListVO();
        vo.setList(rangeUserList);
        return ActionResult.success((Object)vo);
    }
}

