/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.service.SynPushToThirdQyService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.mapper.UserRelationMapper;
import com.bringspring.system.permission.model.permission.PermissionModel;
import com.bringspring.system.permission.model.userrelation.UserRelationForm;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DSTransactional
public class UserRelationServiceImpl
extends ServiceImpl<UserRelationMapper, UserRelationEntity>
implements UserRelationService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private Executor threadPoolExecutor;
    @Autowired
    private SynPushToThirdQyService synPushToThirdQyService;

    @Override
    public UserRelationEntity createAuthorizeAddress(List<String> address, List<String> userId) {
        UserInfo userInfo = this.userProvider.get();
        Object collect = "";
        UserRelationEntity userRelationEntity = new UserRelationEntity();
        if (ObjectUtil.isNotEmpty(address)) {
            String[] addressStr = address.toArray(new String[0]);
            ArrayList<String> list1 = new ArrayList<String>();
            for (String s2 : addressStr) {
                list1.add(s2);
            }
            collect = list1.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
            collect = "[" + (String)collect + "]";
        }
        if (ObjectUtil.isNotEmpty(userId)) {
            for (String s3 : userId) {
                QueryWrapper userRelationEntityQueryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)userRelationEntityQueryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)s3)).eq(UserRelationEntity::getObjectId, (Object)((String)collect).replaceAll(" ", ""));
                UserRelationEntity one = (UserRelationEntity)this.userRelationService.getOne((Wrapper)userRelationEntityQueryWrapper);
                if (ObjectUtil.isNotEmpty((Object)one)) continue;
                String mainId = RandomUtil.uuId();
                userRelationEntity.setUserId(s3);
                userRelationEntity.setId(mainId);
                userRelationEntity.setObjectType("Area");
                userRelationEntity.setObjectId(((String)collect).replaceAll(" ", ""));
                userRelationEntity.setCreatorUserId(userInfo.getUserId());
                userRelationEntity.setCreatorTime(DateUtil.getNowDate());
                this.userRelationService.save(userRelationEntity);
            }
        }
        return userRelationEntity;
    }

    @Override
    public List<UserRelationEntity> getListByUserId(String userId) {
        return this.getListByUserIdAll(Collections.singletonList(userId));
    }

    @Override
    public List<UserRelationEntity> getListByUserIdAndObjType(String userId, String objectType) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().in(UserRelationEntity::getUserId, new Object[]{userId});
        query.lambda().in(UserRelationEntity::getObjectType, new Object[]{objectType});
        ((LambdaQueryWrapper)query.lambda().orderByAsc(UserRelationEntity::getSortCode)).orderByDesc(UserRelationEntity::getCreatorTime);
        return this.list((Wrapper)query);
    }

    @Override
    public List<UserRelationEntity> getListByUserIdAndObjType(List<String> userIds, String objectType) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().in(UserRelationEntity::getUserId, userIds);
        query.lambda().eq(UserRelationEntity::getObjectType, (Object)objectType);
        ((LambdaQueryWrapper)query.lambda().orderByAsc(UserRelationEntity::getSortCode)).orderByDesc(UserRelationEntity::getCreatorTime);
        return this.list((Wrapper)query);
    }

    @Override
    public List<UserRelationEntity> getListByUserIdAll(List<String> userId) {
        if (userId.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserRelationEntity::getUserId, userId);
            return this.list((Wrapper)queryWrapper);
        }
        return new ArrayList<UserRelationEntity>();
    }

    @Override
    public List<UserRelationEntity> getListByObjectId(String objectId) {
        return this.getListByObjectId(objectId, null);
    }

    @Override
    public List<UserRelationEntity> getListByObjectId(String objectId, String objectType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)objectId)) {
            queryWrapper.lambda().eq(UserRelationEntity::getObjectId, (Object)objectId);
        }
        if (objectType != null) {
            queryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)objectType);
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserRelationEntity::getSortCode)).orderByDesc(UserRelationEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<UserRelationEntity> getListByUserIdAndObjectId(String userId, String objectId, String objectType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserRelationEntity::getUserId, (Object)userId);
        queryWrapper.lambda().eq(UserRelationEntity::getObjectId, (Object)objectId);
        if (objectType != null) {
            queryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)objectType);
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserRelationEntity::getSortCode)).orderByDesc(UserRelationEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<UserRelationEntity> getListByUserIdAndObjectId(List<String> userIds, String objectId, String objectType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(UserRelationEntity::getUserId, userIds);
        queryWrapper.lambda().eq(UserRelationEntity::getObjectId, (Object)objectId);
        if (objectType != null) {
            queryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)objectType);
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(UserRelationEntity::getSortCode)).orderByDesc(UserRelationEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<UserRelationEntity> getListByObjectIdAll(List<String> objectId) {
        List<UserRelationEntity> list = new ArrayList<UserRelationEntity>();
        if (objectId.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserRelationEntity::getObjectId, objectId);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public List<UserRelationEntity> getListByJointKey(List<String> userIds, List<String> objectIds, List<String> objectTypes) {
        List<UserRelationEntity> list = new ArrayList<UserRelationEntity>();
        if (CollectionUtil.isNotEmpty(userIds) && CollectionUtil.isNotEmpty(objectIds) && CollectionUtil.isNotEmpty(objectTypes)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserRelationEntity::getUserId, userIds);
            queryWrapper.lambda().in(UserRelationEntity::getObjectId, objectIds);
            queryWrapper.lambda().in(UserRelationEntity::getObjectType, objectTypes);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public void deleteAllByObjId(String objId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserRelationEntity::getObjectId, (Object)objId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void deleteAllByUserId(String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(UserRelationEntity::getUserId, (Object)userId)).notLike(UserRelationEntity::getObjectType, (Object)"Area");
        this.userRelationService.remove((Wrapper)queryWrapper);
    }

    @Override
    public UserRelationEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserRelationEntity::getId, (Object)id);
        return (UserRelationEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void save(String objectId, List<UserRelationEntity> entitys) {
        List<UserRelationEntity> existList = this.getListByObjectId(objectId);
        ArrayList<UserRelationEntity> relationList = new ArrayList<UserRelationEntity>();
        for (int i = 0; i < entitys.size(); ++i) {
            UserRelationEntity entity = entitys.get(i);
            entity.setId(RandomUtil.uuId());
            entity.setSortCode(Long.parseLong("" + i));
            entity.setCreatorUserId(this.userProvider.get().getUserId());
            if (existList.stream().filter(t -> t.getUserId().equals(entity.getUserId())).count() != 0L) continue;
            relationList.add(entity);
        }
        for (UserRelationEntity entity : relationList) {
            this.save(entity);
        }
    }

    @Override
    public Boolean judgeAuthorize(List<String> address, String userId) {
        String[] addressStr = address.toArray(new String[0]);
        ArrayList<String> listOne = new ArrayList<String>();
        for (String s2 : addressStr) {
            listOne.add(s2);
        }
        List<Object> listTwo = new ArrayList();
        if (listOne.size() > 1) {
            Object str = (String)listOne.get(0);
            str = "[\"" + (String)str + "\"]";
            listTwo = this.userRelationService.getListByObjectId(((String)str).replaceAll(" ", ""), "Area");
        }
        Object collect = listOne.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
        collect = "[" + (String)collect + "]";
        List<UserRelationEntity> list = this.userRelationService.getListByObjectId(((String)collect).replaceAll(" ", ""), "Area");
        if (ObjectUtil.isNotEmpty(listTwo)) {
            list.addAll(listTwo);
        }
        boolean flag = false;
        for (UserRelationEntity userRelationEntity : list) {
            if (!userRelationEntity.getUserId().equals(userId)) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public void save(List<UserRelationEntity> list) {
        for (UserRelationEntity entity : list) {
            this.save(entity);
        }
    }

    @Override
    @DSTransactional
    public void delete(String[] ids) {
        for (String item : ids) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(UserRelationEntity::getId, (Object)item);
            this.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    @DSTransactional
    public void saveObjectId(String objectId, UserRelationForm userRelationForm) {
        List beforeUserIds = this.userRelationService.getListByObjectId(objectId).stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        this.deleteAllByObjId(objectId);
        UserInfo userInfo = this.userProvider.get();
        ArrayList<UserRelationEntity> list = new ArrayList<UserRelationEntity>();
        int i = 0;
        for (String userId : userRelationForm.getUserIds()) {
            UserRelationEntity entity = new UserRelationEntity();
            entity.setId(RandomUtil.uuId());
            entity.setSortCode(Long.parseLong("" + i));
            entity.setObjectId(objectId);
            entity.setObjectType(userRelationForm.getObjectType());
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setUserId(userId);
            list.add(entity);
            ++i;
        }
        this.save(objectId, list);
        List unUpdateUserId = beforeUserIds.stream().filter(b -> userRelationForm.getUserIds().contains(b)).collect(Collectors.toList());
        beforeUserIds.addAll(userRelationForm.getUserIds());
        List<String> allUpdateIds = beforeUserIds.stream().filter(u -> !unUpdateUserId.contains(u)).collect(Collectors.toList());
        if ("Position".equals(userRelationForm.getObjectType())) {
            this.organizeRelationService.autoSetPosition(allUpdateIds);
        }
    }

    @Override
    public void roleSaveByUserIds(String roleId, List<String> userIds) {
        this.deleteAllByObjId(roleId);
        String currentUserId = this.userProvider.get().getId();
        ArrayList<UserRelationEntity> userRelationList = new ArrayList<UserRelationEntity>();
        for (String userId : userIds) {
            UserRelationEntity entity = new UserRelationEntity();
            entity.setId(RandomUtil.uuId());
            entity.setObjectId(roleId);
            entity.setObjectType("Role");
            entity.setCreatorUserId(currentUserId);
            entity.setUserId(userId);
            userRelationList.add(entity);
        }
        this.saveBatch(userRelationList);
    }

    @Override
    @DSTransactional
    public void organizeSaveByUserIds(String objectId, List<String> userIds) {
        List<UserEntity> updateUserList;
        List<UserRelationEntity> listByObjectId = this.getListByObjectId(objectId, "Organize");
        List users = listByObjectId.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        ArrayList<String> updateUserIds = new ArrayList<String>();
        List addRelation = userIds.stream().filter(t -> !users.contains(t)).collect(Collectors.toList());
        updateUserIds.addAll(addRelation);
        List<String> removeRelation = users.stream().filter(t -> !userIds.contains(t)).collect(Collectors.toList());
        ArrayList removeIds = new ArrayList();
        List updateUserOrganizeId = null;
        if (CollectionUtil.isNotEmpty(removeRelation)) {
            List<UserRelationEntity> listByUserIdAndObjType = this.getListByUserIdAndObjType(removeRelation, "Organize");
            List<String> removeReally = removeRelation.stream().filter(i -> listByUserIdAndObjType.stream().filter(t -> t.getUserId().equals(i)).count() > 1L).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(removeReally)) {
                updateUserIds.addAll(removeReally);
                List<UserRelationEntity> userOrg = this.getListByUserIdAndObjectId(removeReally, objectId, "Organize");
                removeIds.addAll(userOrg.stream().map(t -> t.getId()).collect(Collectors.toList()));
                List<UserEntity> userList = this.userService.getUserList(removeReally);
                updateUserOrganizeId = userList.stream().filter(t -> objectId.equals(t.getOrganizeId())).collect(Collectors.toList());
                for (UserEntity userEntity : updateUserOrganizeId) {
                    List organizeList = listByUserIdAndObjType.stream().filter(t -> t.getUserId().equals(userEntity.getId()) && !objectId.equals(t.getObjectId())).collect(Collectors.toList());
                    userEntity.setOrganizeId(((UserRelationEntity)organizeList.get(0)).getObjectId());
                }
                ArrayList<String> objectIds = new ArrayList<String>();
                List roles = this.organizeRelationService.getListByTypeAndOrgId("Role", objectId).stream().map(OrganizeRelationEntity::getObjectId).collect(Collectors.toList());
                objectIds.addAll(roles);
                List positionIds = this.positionService.getListByOrganizeId(objectId).stream().map(PermissionEntityBase::getId).collect(Collectors.toList());
                objectIds.addAll(positionIds);
                ArrayList<String> objectTypes = new ArrayList<String>();
                objectTypes.add("Role");
                objectTypes.add("Position");
                List relationIds = this.getListByJointKey(removeReally, objectIds, objectTypes).stream().map(UserRelationEntity::getId).collect(Collectors.toList());
                removeIds.addAll(relationIds);
            }
        }
        if (CollectionUtil.isNotEmpty(addRelation)) {
            ArrayList<UserRelationEntity> userRelationList = new ArrayList<UserRelationEntity>();
            for (String userId : addRelation) {
                UserRelationEntity entity = new UserRelationEntity();
                entity.setId(RandomUtil.uuId());
                entity.setObjectId(objectId);
                entity.setObjectType("Organize");
                entity.setCreatorUserId(this.userProvider.get().getId());
                entity.setUserId(userId);
                userRelationList.add(entity);
            }
            this.saveBatch(userRelationList);
        }
        if (CollectionUtil.isNotEmpty(removeIds)) {
            if (CollectionUtil.isNotEmpty(updateUserOrganizeId)) {
                this.userService.updateBatchById(updateUserOrganizeId);
            }
            this.removeBatchByIds(removeIds);
        }
        if (CollectionUtil.isNotEmpty(updateUserList = this.userService.getUserList(updateUserIds))) {
            for (UserEntity entity : updateUserList) {
                this.threadPoolExecutor.execute(() -> {
                    try {
                        this.synPushToThirdQyService.updateUserSysToQy(this.userProvider.get(), false, entity, null);
                    }
                    catch (Exception e) {
                        this.log.error("\u4fee\u6539\u7528\u6237\u4e4b\u540e\u540c\u6b65\u5931\u8d25\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                });
            }
        }
    }

    @Override
    public List<UserRelationEntity> getListByObjectType(String userId, String objectType) {
        QueryWrapper query = new QueryWrapper();
        ((LambdaQueryWrapper)query.lambda().eq(UserRelationEntity::getUserId, (Object)userId)).eq(UserRelationEntity::getObjectType, (Object)objectType);
        ((LambdaQueryWrapper)query.lambda().orderByAsc(UserRelationEntity::getSortCode)).orderByDesc(UserRelationEntity::getCreatorTime);
        return this.list((Wrapper)query);
    }

    @Override
    public List<UserRelationEntity> getAllOrgRelationByUserId(String userId) {
        return this.getListByObjectType(userId, "Organize");
    }

    @Override
    public List<PermissionModel> getObjectVoList(String objectType) {
        String userId = this.userProvider.get().getUserId();
        UserEntity userEntity = this.userService.getInfo(userId);
        String majorOrgId = this.userProvider.get().getDepartmentId();
        switch (objectType) {
            case "Organize": {
                ArrayList<String> ids = new ArrayList<String>();
                this.getListByObjectType(userId, objectType).forEach(r -> ids.add(r.getObjectId()));
                List<PermissionModel> permissionModels = this.setModel(this.organizeService.getOrgEntityList(ids, false), majorOrgId);
                permissionModels.forEach(p -> p.setFullName(PermissionUtil.getLinkInfoByOrgId(p.getId(), this.organizeService, false)));
                return permissionModels;
            }
            case "Position": {
                List<PositionEntity> positionList = this.positionService.getListByUserId(userId);
                if (positionList.size() <= 0) break;
                return this.setModel(positionList.stream().filter(p -> p.getOrganizeId().equals(majorOrgId)).collect(Collectors.toList()), userEntity.getPositionId());
            }
        }
        return null;
    }

    @Override
    public List<PermissionModel> getObjectVoListById(String id, String objectType) {
        String userId = id;
        UserEntity userEntity = this.userService.getInfo(userId);
        String majorOrgId = userEntity.getOrganizeId();
        switch (objectType) {
            case "Organize": {
                ArrayList<String> ids = new ArrayList<String>();
                this.getListByObjectType(userId, objectType).forEach(r -> ids.add(r.getObjectId()));
                List<PermissionModel> permissionModels = this.setModel(this.organizeService.getOrgEntityList(ids, false), majorOrgId);
                permissionModels.forEach(p -> p.setFullName(PermissionUtil.getLinkInfoByOrgId(p.getId(), this.organizeService, false)));
                return permissionModels;
            }
            case "Position": {
                List<PositionEntity> positionList = this.positionService.getListByUserId(userId);
                if (positionList.size() <= 0) break;
                return this.setModel(positionList.stream().filter(p -> p.getOrganizeId().equals(majorOrgId)).collect(Collectors.toList()), userEntity.getPositionId());
            }
        }
        return null;
    }

    @Override
    public <T extends PermissionEntityBase> List<PermissionModel> setModel(List<T> permissionList, String majorId) {
        ArrayList<PermissionModel> voList = new ArrayList<PermissionModel>();
        permissionList.forEach(p -> {
            PermissionModel model = new PermissionModel();
            if (p.getId().equals(majorId)) {
                model.setIsDefault(true);
            } else {
                model.setIsDefault(false);
            }
            model.setFullName(p.getFullName());
            model.setId(p.getId());
            model.setFullName(p.getFullName());
            voList.add(model);
        });
        return voList;
    }

    @Override
    public Boolean existByObjectId(String objectId, String objectType) {
        QueryWrapper query = new QueryWrapper();
        ((LambdaQueryWrapper)query.lambda().eq(UserRelationEntity::getObjectType, (Object)objectType)).eq(UserRelationEntity::getObjectId, (Object)objectId);
        return this.count((Wrapper)query) > 0L;
    }

    @Override
    public List<UserRelationEntity> getListByRoleId(String roleId) {
        ArrayList<UserRelationEntity> list = new ArrayList<UserRelationEntity>();
        this.organizeRelationService.getRelationListByRoleId(roleId).forEach(o -> {
            QueryWrapper query = new QueryWrapper();
            ((LambdaQueryWrapper)query.lambda().eq(UserRelationEntity::getObjectType, (Object)"Organize")).eq(UserRelationEntity::getObjectId, (Object)o.getOrganizeId());
            list.addAll(this.list((Wrapper)query));
        });
        return list;
    }

    @Override
    public List<UserRelationEntity> getListByRoleIds(String roleId) {
        List<UserRelationEntity> list = this.userRelationService.getListByObjectId(roleId);
        return list;
    }

    @Override
    public List<UserRelationEntity> getListByUserId(String userId, String objectType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserRelationEntity::getUserId, (Object)userId);
        queryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)objectType);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<UserRelationEntity> getListByOrgId(List<String> orgIdList) {
        if (CollectionUtil.isEmpty(orgIdList)) {
            return new ArrayList<UserRelationEntity>();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)"Organize");
        queryWrapper.lambda().in(UserRelationEntity::getObjectId, orgIdList);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public String getAllOrganizeNameInfoById(String id) {
        List<UserRelationEntity> orgRelationListByUserId = this.userRelationService.getAllOrgRelationByUserId(id);
        StringBuilder organize = new StringBuilder();
        String organizeName = "";
        for (UserRelationEntity userRelationEntity : orgRelationListByUserId) {
            String organizeIdTree;
            OrganizeEntity entity = this.organizeService.getInfo(userRelationEntity.getObjectId());
            if (entity == null || !StringUtils.isNotEmpty((String)(organizeIdTree = entity.getOrganizeIdTree()))) continue;
            String[] orgId = organizeIdTree.split(",");
            List<OrganizeEntity> organizeNameList = this.organizeService.getOrganizeNameSort(Arrays.asList(orgId));
            StringBuilder orgName = new StringBuilder();
            for (OrganizeEntity organizeEntity : organizeNameList) {
                orgName.append("/" + organizeEntity.getFullName());
            }
            if (orgName.length() <= 0) continue;
            organize.append(";" + orgName.toString().replaceFirst("/", ""));
        }
        if (organize.length() > 0) {
            organizeName = organize.toString().replaceFirst(";", "");
        }
        return organizeName;
    }
}

