/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.strategy;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.strategy.FieldContentStringStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentStringOrganizationAndSuborganization
extends FieldContentStringStrategy {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;

    public ContentStringOrganizationAndSuborganization() {
        this.order = 20;
        this.conditionOptions = new ArrayList();
        this.conditionOptions.add(new HashMap<String, Object>(){
            {
                this.put("value", AuthorizeConditionEnum.ORGANIZEANDUNDER.getCondition());
                this.put("label", AuthorizeConditionEnum.ORGANIZEANDUNDER.getMessage());
            }
        });
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsBatch();
    }

    @Override
    public Object convertFieldContent(String fieldContent, String symbol) {
        ArrayList<String> underOrganizations = new ArrayList<String>();
        String orgId = this.userProvider.get().getOrganizeId();
        if (StringUtils.isNotEmpty((String)this.userProvider.get().getDepartmentId())) {
            orgId = this.userProvider.get().getDepartmentId();
        }
        underOrganizations.add(orgId);
        underOrganizations.addAll(this.organizeService.getUnderOrganizations(orgId));
        return underOrganizations;
    }
}

