/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.scheduletask.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.task.LocalTaskModel;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.util.jobutil.TimeUtil;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.entity.TimeTaskLogEntity;
import com.bringspring.system.scheduletask.mapper.TimeTaskMapper;
import com.bringspring.system.scheduletask.model.ContentModel;
import com.bringspring.system.scheduletask.model.TaskPage;
import com.bringspring.system.scheduletask.service.TimeTaskLogService;
import com.bringspring.system.scheduletask.service.TimetaskService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimetaskServiceImpl
extends ServiceImpl<TimeTaskMapper, TimeTaskEntity>
implements TimetaskService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private TimeTaskLogService timeTaskLogService;
    @Autowired
    private ConcurrentHashMap<String, LocalTaskModel> concurrentHashMap;

    @Override
    public List<TimeTaskEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TimeTaskEntity::getEnabledMark, (Object)1);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(TimeTaskEntity::getSortCode)).orderByDesc(TimeTaskEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<TimeTaskEntity> getList(Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (pagination.getKeyword() != null) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(TimeTaskEntity::getEnCode, (Object)pagination.getKeyword())).or()).like(TimeTaskEntity::getFullName, (Object)pagination.getKeyword()));
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(TimeTaskEntity::getSortCode)).orderByDesc(TimeTaskEntity::getCreatorTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public List<TimeTaskLogEntity> getTaskLogList(String taskId, TaskPage pagination) {
        String endTime;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TimeTaskLogEntity::getTaskId, (Object)taskId);
        String startTime = pagination.getStartTime() != null ? pagination.getStartTime() : null;
        String string = endTime = pagination.getEndTime() != null ? pagination.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(TimeTaskLogEntity::getRunTime, (Object)startTimes)).le(TimeTaskLogEntity::getRunTime, (Object)endTimes);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(TimeTaskLogEntity::getRunTime);
        } else {
            QueryWrapper queryWrapper2 = queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)pagination.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)pagination.getSidx());
        }
        if (pagination.getRunResult() != null) {
            queryWrapper.lambda().eq(TimeTaskLogEntity::getRunResult, (Object)pagination.getRunResult());
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.timeTaskLogService.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public TimeTaskEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TimeTaskEntity::getId, (Object)id);
        return (TimeTaskEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TimeTaskEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(TimeTaskEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TimeTaskEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(TimeTaskEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void create(TimeTaskEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        String token = UserProvider.getToken();
        entity.setId(RandomUtil.uuId());
        entity.setEnabledMark(1);
        entity.setCreatorUserId(userInfo.getUserId());
        ContentModel model = (ContentModel)JsonUtil.getJsonToBean((String)entity.getExecuteContent(), ContentModel.class);
        if ("3".equals(entity.getExecuteType()) && StringUtils.isEmpty((String)entity.getExecuteCronExpression()) && this.concurrentHashMap.containsKey(model.getLocalHostTaskId())) {
            LocalTaskModel taskModel = this.concurrentHashMap.get(model.getLocalHostTaskId());
            entity.setExecuteCronExpression(taskModel.getCron());
            model.setCron(taskModel.getCron());
        }
        if (this.save(entity)) {
            this.start(model, entity, userInfo, token);
        }
    }

    @Override
    public boolean update(String id, TimeTaskEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        String token = UserProvider.getToken();
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        entity.setLastModifyUserId(userInfo.getUserId());
        ContentModel model = (ContentModel)JsonUtil.getJsonToBean((String)entity.getExecuteContent(), ContentModel.class);
        if (this.isjson(entity.getExecuteContent())) {
            if ("3".equals(entity.getExecuteType()) && StringUtils.isEmpty((String)entity.getExecuteCronExpression()) && this.concurrentHashMap.containsKey(model.getLocalHostTaskId())) {
                LocalTaskModel taskModel = this.concurrentHashMap.get(model.getLocalHostTaskId());
                entity.setExecuteCronExpression(taskModel.getCron());
                model.setCron(taskModel.getCron());
            }
            if (this.updateById(entity)) {
                this.del(entity, userInfo);
                if (entity.getEnabledMark() == 1) {
                    this.start(model, entity, userInfo, token);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void delete(TimeTaskEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        if (this.removeById((Serializable)((Object)entity.getId()))) {
            this.del(entity, userInfo);
            this.timeTaskLogService.delete(entity.getId());
        }
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        TimeTaskEntity upEntity = (TimeTaskEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().lt(TimeTaskEntity::getSortCode, (Object)upSortCode)).orderByDesc(TimeTaskEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((TimeTaskEntity)downEntity.get(0)).getSortCode());
            ((TimeTaskEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById((TimeTaskEntity)downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        TimeTaskEntity downEntity = (TimeTaskEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().gt(TimeTaskEntity::getSortCode, (Object)upSortCode)).orderByAsc(TimeTaskEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((TimeTaskEntity)upEntity.get(0)).getSortCode());
            ((TimeTaskEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById((TimeTaskEntity)upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public void createTaskLog(TimeTaskLogEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setRunTime(DateUtil.getNowDate());
        this.timeTaskLogService.save(entity);
    }

    private boolean isjson(String string) {
        try {
            JSONObject jsonStr = JSONObject.parseObject((String)string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void start(ContentModel model, TimeTaskEntity entity, UserInfo userInfo, String token) {
        TimeUtil.startJob(model, userInfo, entity, token);
    }

    @Override
    public boolean jobStartNow(String id, TimeTaskEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        String token = UserProvider.getToken();
        ContentModel model = (ContentModel)JsonUtil.getJsonToBean((String)entity.getExecuteContent(), ContentModel.class);
        if (this.isjson(entity.getExecuteContent())) {
            TimeUtil.startJobNow(model, userInfo, entity, token);
        }
        return true;
    }

    @Override
    public List<TimeTaskEntity> getListByContent(String content) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(TimeTaskEntity::getExecuteContent, (Object)content);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<TimeTaskEntity> getListByEncode(String content) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TimeTaskEntity::getEnCode, (Object)content);
        return this.list((Wrapper)queryWrapper);
    }

    private void del(TimeTaskEntity entity, UserInfo userInfo) {
        TimeUtil.removeJob(entity, userInfo);
    }
}

