package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
@TableName("BASE_DATA_INTERFACE")
public class DataInterfaceEntity {
    /**
     * 主键ID
     */
    @TableId("ID")
    private String id;

    /**
     * 分组ID
     */
    @TableField("CATEGORY_ID")
    private String categoryId;

    /**
     * 接口名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 数据源id
     */
    @TableField("DB_LINK_ID")
    private String dbLinkId;

    /**
     * 数据类型(1-动态数据SQL查询，2-静态数据,3-Api数据)
     */
    @TableField("DATA_TYPE")
    private Integer dataType;

    /**
     * 接口路径
     */
    @TableField("PATH")
    private String path;

    /**
     * 请求方式
     *
     * 为Sql时 1-增加，2-修改，3-查询，4-删除，5-存储
     * 为Api时 6-get，7-post
     */
    @TableField("REQUEST_METHOD")
    private String requestMethod;

    /**
     * 返回类型
     */
    @TableField("RESPONSE_TYPE")
    private String responseType;

    /**
     * 查询语句
     */
    @TableField("Query")
    private String query;

    /**
     * 请求头参数
     */
    @TableField("Request_Headers")
    private String requestHeaders;

    /**
     * 验证类型   0-不验证，1-授权验证，2-域名验证
     */
    @TableField("Check_Type")
    private Integer checkType;

    /**
     * 请求参数JSON
     */
    @TableField("Request_Parameters")
    private String requestParameters;

    /**
     * 返回参数JSON
     */
    @TableField("Ip_Address")
    private String ipAddress;

    /**
     * 数据处理
     */
    @TableField("DATA_PROCESSING")
    private String dataProcessing;

    /**
     * 接口编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 排序码(默认0)
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 状态(0-默认，禁用，1-启用)
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 描述或说明
     */
    @TableField("Description")
    private String description;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;


}
