package com.bringspring.system.base.exception;


import lombok.Getter;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/**
 * 登陆异常
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 10:10
 */
@Getter
public class LoginException extends UsernameNotFoundException {
    /**
     * http状态码
     */
    private Integer code;

    private Object object;

    public LoginException(String message) {
        super(message);
    }

    public LoginException(String message, int code) {
        super(message);
        this.code = code;
    }

    public LoginException(String message, int code, Object object) {
        super(message);
        this.code = code;
        this.object = object;
    }

}
