package com.bringspring.system.base.model.dataInterface;

import lombok.Data;

import java.io.Serializable;

/**
 * 数据接口模型
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-12-13
 */
@Data
public class DataInterfaceModel implements Serializable {
    /**
     * 参数名称
     */
    private String field;

    /**
     * 列说明
     */
    private String fieldName;

    /**
     * 参数类型
     * 字符串  1
     * 整型    2
     * 日期时间 3
     * 浮点   4
     * 长整型  5
     * 文本   6
     */
    private Integer fieldType;

    /**
     * 是否为空（1允许，0不允许）
     */
    private String allowNull;

    /**
     * 默认值
     */
    private String defaultValue;
}
