package com.bringspring.system.base.model.province;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 * 行政区划
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-12-11
 */
@Data
public class ProvinceSelector {
    @Schema(description = "主键")
    private String id;
    @Schema(description = "父主键")
    private String parentId;
    @Schema(description = "编码")
    private String enCode;
    @Schema(description = "名称")
    private String fullName;
    @Schema(description = "快速查询")
    private String quickQuery;
    @Schema(description = "区域类型")
    private String type;
    @Schema(description = "城市级别")
    private Integer cityLevel;
    @Schema(description = "简称")
    private String provSimpleName;
    @Schema(description = "祖宗ids")
    private String parentIdTree;
    @Schema(description = "描述")
    private String description;
    @Schema(description = "图标")
    private String icon;
    @Schema(description = "是否可用")
    private Integer enabledMark;
    @Schema(description = "是否有下级")
    private Boolean hasChildren;
    @Schema(description = "下级列表")
    private List<ProvinceSelector> children;
}
