package com.bringspring.system.base.service.impl;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.system.base.service.BaseModuleOffenService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service
public class BaseModuleOffenServiceImpl implements BaseModuleOffenService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;

    @Override
    public List<String> getList() {
        UserInfo userInfo = userProvider.get();
        UserEntity userEntity = userService.getById(userInfo.getUserId());
        List<String> list = new ArrayList<>(); // 创建一个空的列表来存放结果
        if (Objects.nonNull(userEntity.getCommonMenu())){
            for (String s : userEntity.getCommonMenu().split(",")) {
                list.add(s); // 将值添加到列表中
            }
        }

        return list;
    }
}
