package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.mapper.BaseSyncThirdInfoMapper;
import com.bringspring.system.base.model.baseSyncThirdInfo.BaseSyncThirdInfoPagination;
import com.bringspring.system.base.service.BaseSyncThirdInfoService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * 第三方同步
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-08-19
 */
@Service
public class BaseSyncThirdInfoServiceImpl extends ServiceImpl<BaseSyncThirdInfoMapper, SynThirdInfoEntity> implements BaseSyncThirdInfoService {


    @Autowired
    private UserProvider userProvider;


    @Override
    public List<SynThirdInfoEntity> getList(BaseSyncThirdInfoPagination pagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int baseSyncThirdInfoNum = 0;
        QueryWrapper<SynThirdInfoEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getThirdType())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().like(SynThirdInfoEntity::getThirdType, pagination.getThirdType());
        }

        //同步状态
        if (StringUtils.isNotEmpty(pagination.getSynState())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().eq(SynThirdInfoEntity::getSynState, pagination.getSynState());
        }


        if (StringUtils.isNotEmpty(pagination.getDataType())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().like(SynThirdInfoEntity::getDataType, pagination.getDataType());
        }

        if (StringUtils.isNotEmpty(pagination.getSystemObjectId())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().like(SynThirdInfoEntity::getSystemObjectId, pagination.getSystemObjectId());
        }

        if (StringUtils.isNotEmpty(pagination.getThirdObjectId())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().like(SynThirdInfoEntity::getThirdObjectId, pagination.getThirdObjectId());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(SynThirdInfoEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(SynThirdInfoEntity::getLastModifyTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
                Field declaredField = synThirdInfoEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<SynThirdInfoEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
            IPage<SynThirdInfoEntity> userIPage = this.page(page, queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<SynThirdInfoEntity> list = new ArrayList();
            return pagination.setData(list, list.size());
        }
    }

    @Override
    public List<SynThirdInfoEntity> getTypeList(BaseSyncThirdInfoPagination pagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int baseSyncThirdInfoNum = 0;
        QueryWrapper<SynThirdInfoEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getThirdType())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().like(SynThirdInfoEntity::getThirdType, pagination.getThirdType());
        }

        if (StringUtils.isNotEmpty(pagination.getDataType())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().like(SynThirdInfoEntity::getDataType, pagination.getDataType());
        }

        if (StringUtils.isNotEmpty(pagination.getSystemObjectId())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().like(SynThirdInfoEntity::getSystemObjectId, pagination.getSystemObjectId());
        }

        if (StringUtils.isNotEmpty(pagination.getThirdObjectId())) {
            baseSyncThirdInfoNum++;
            queryWrapper.lambda().like(SynThirdInfoEntity::getThirdObjectId, pagination.getThirdObjectId());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(SynThirdInfoEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(SynThirdInfoEntity::getLastModifyTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
                Field declaredField = synThirdInfoEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<SynThirdInfoEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
                IPage<SynThirdInfoEntity> userIPage = this.page(page, queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<SynThirdInfoEntity> list = new ArrayList();
                return pagination.setData(list, list.size());
            }
        } else {
            return this.list(queryWrapper);
        }
    }

    @Override
    public SynThirdInfoEntity getInfo(String id) {
        QueryWrapper<SynThirdInfoEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SynThirdInfoEntity::getId, id);
        return this.getOne(queryWrapper);
    }

}