package com.bringspring.system.base.service.impl;


import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcOriginUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.service.DbSyncService;
import com.bringspring.system.base.service.DbTableService;
import com.bringspring.system.base.service.DblinkService;
import lombok.Cleanup;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.util.List;

/**
 * 数据同步
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Slf4j
@Service
public class DbSyncServiceImpl implements DbSyncService {

    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private DbTableService dbTableService;

    @Override
    public Integer checkExecute(String dbLinkIdFrom, String dbLinkIdTo, String table) throws Exception {
        DbLinkEntity linkFrom = dblinkService.getInfo(dbLinkIdFrom);
        DbLinkEntity linkTo = dblinkService.getInfo(dbLinkIdTo);
        //验证一（同库）
        if (dbLinkIdFrom.equals(dbLinkIdTo) ||
                (linkFrom.getHost() + linkFrom.getPort() + linkFrom.getDbName())
                        .equals(linkTo.getHost() + linkTo.getPort() + linkTo.getDbName())) {
            return -1;
        }
        @Cleanup Connection connFrom = ConnUtil.getConn(linkFrom);
        @Cleanup Connection connTo = ConnUtil.getConn(linkTo);
        //验证二（表存在）
        if (dbTableService.getList(linkTo.getId()).stream().filter(tableOne ->
                tableOne.getTable().equals(table)).count() == 0) {
            // 被同步表不存在
            return 2;
        } else {
            //验证三（验证表数据）
            String toSql = "SELECT count(*) AS CREATOR_TIMECOUNT FROM ?;";
            if (JdbcUtil.queryOneInt(new PreparedStatementDTO(connTo, toSql),"CREATOR_TIMECOUNT") > 0) {
                //被同步表存在数据
                return 3;
            }
        }
        syncTable(connFrom, connTo, table);
        return 0;
    }

    @Override
    public void executeImport(String dbLinkIdFrom, String dbLinkIdTo, String table) throws Exception {
        @Cleanup Connection connFrom = ConnUtil.getConn(dblinkService.getInfo(dbLinkIdFrom));
        @Cleanup Connection connTo = ConnUtil.getConn(dblinkService.getInfo(dbLinkIdTo));
        SqlBase sqlBase = DbTypeUtil.getDb(connTo).getSqlBase();
        // 删除To表
        JdbcUtil.creUpDe(sqlBase.getDeleteSqlPSD(connTo, table));
        DbBase dbBase = DbTypeUtil.getDb(connTo);
        //获取建表语句
        JdbcUtil.creUpDeBatch(connTo,
                sqlBase.getCreateTablePSD(
                        table,
                        JdbcOriginUtil.getTableInfo(connFrom, table).getComment(),
                        JdbcOriginUtil.getFields(connFrom, table),dbBase));
        //同步数据
        syncTable(connFrom, connTo, table);
    }

    private void syncTable(Connection connFrom, Connection connTo, String table) throws DataException {
        //初始库Form
        String fromSql = "SELECT * FROM " + table;
        List<List<DbFieldMod>> dataList = JdbcUtil.queryIncludeFieldMods(new PreparedStatementDTO(connFrom, fromSql));
        if (dataList.size() > 0){
            //被同步库同步To
            String sqlData = DbTypeUtil.getDb(connTo).getSqlBase().batchInsertSql(dataList, table);
            JdbcUtil.creUpDe(new PreparedStatementDTO(connTo, sqlData));
        }
    }


}
