package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.SmsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SmsTemplateEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.mapper.SmsTemplateMapper;
import com.bringspring.system.base.service.SmsTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @author Administrator
* @description 针对表【base_sms_template】的数据库操作Service实现
* @createDate 2021-12-09 10:12:52
*/
@Service
public class SmsTemplateServiceImpl extends ServiceImpl<SmsTemplateMapper, SmsTemplateEntity> implements SmsTemplateService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;

    @Override
    public List<SmsTemplateEntity> getList() {
        QueryWrapper<SmsTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SmsTemplateEntity::getEnabledMark, 1);
        queryWrapper.lambda().orderByDesc(SmsTemplateEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<SmsTemplateEntity> getList(Pagination pagination) {
        QueryWrapper<SmsTemplateEntity> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(pagination.getKeyword())) {
            queryWrapper.lambda().and(
                    t -> t.like(SmsTemplateEntity::getTemplateId, pagination.getKeyword())
                            .or().like(SmsTemplateEntity::getFullName, pagination.getKeyword())
                            .or().like(SmsTemplateEntity::getEnCode, pagination.getKeyword())
            );
        }
        queryWrapper.lambda().orderByDesc(SmsTemplateEntity::getCreatorTime);
        Page<SmsTemplateEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
        IPage<SmsTemplateEntity> userPage = this.page(page, queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public SmsTemplateEntity getInfo(String id) {
        QueryWrapper<SmsTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SmsTemplateEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void create(SmsTemplateEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String id, SmsTemplateEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(SmsTemplateEntity entity) {
        this.removeById(entity.getId());
    }

    @Override
    public boolean isExistByTemplateName(String templateName, String id) {
        QueryWrapper<SmsTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SmsTemplateEntity::getFullName, templateName);
        if (!StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(SmsTemplateEntity::getId, id);
        }
        return this.count(queryWrapper) > 0;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper<SmsTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SmsTemplateEntity::getEnCode, enCode);
        if (!StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(SmsTemplateEntity::getId, id);
        }
        return this.count(queryWrapper) > 0;
    }

    @Override
    public SmsModel getSmsConfig() {
        // 得到系统配置
        List<SysConfigEntity> configList = sysConfigService.getList();
        Map<String, String> objModel = new HashMap<>(16);
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        SmsModel smsModel = JsonUtil.getJsonToBean(objModel, SmsModel.class);
        return smsModel;
    }

}




