package com.bringspring.system.base.task;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.model.monitor.MonitorListVO;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.MonitorUtil;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.message.util.SentMessageUtil;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

import java.io.File;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class ServiceResourcesTask {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceResourcesTask.class);
    //cpu使用率90.00%
    private static final String CUP_SYSTEM = "90.00";
    //内存使用率90.00%
    private static final String MEMORY_SYSTEM = "90.00";
    //磁盘可用空间大小10G
    private static final String DISK_SYSTEM = "10";
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private SentMessageUtil sentMessageUtil;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    /**
     * 定时获取系统资源，产生告警信息
     */
    @JsbosTask(fullName = "系统资源监控", description = "系统资源监控")
    public void serviceResourcesAlert() throws Exception {
        //获取系统资源
        MonitorUtil monitorUtil = new MonitorUtil();
        MonitorListVO vo = JsonUtil.getJsonToBean(monitorUtil, MonitorListVO.class);
        //cpu使用率
        String cupIdle = vo.getCpu().getUsed();
        //内存使用率
        String memoryUsageRate = vo.getMemory().getUsageRate();

        //应用程序所在路径
        String directoryPath = "";
        //获取系统磁盘空间大小（目前默认两个盘符：应用盘、附件盘）
        // 获取当前类加载器得到应用程序路径
        ClassLoader classLoader = ServiceResourcesTask.class.getClassLoader();
        // 获取当前类（AppPathExample）所在的JAR或者类文件的URI
        URL resource = classLoader.getResource("");
        try {
            // 如果应用程序是从JAR运行的，toURI()会转换为URI格式
            // 然后通过new File()转换为路径
            File directory = new File(resource.toURI());
            directoryPath = directory.getAbsolutePath();
        } catch (URISyntaxException e) {
            LOG.error(e.getMessage());
        }

        //得到附件存储目录
        String filePath = configValueUtil.getDocumentFilePath();

        //获得根目录
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.contains("WINDOWS")) {
            directoryPath = directoryPath.substring(0, 1).toUpperCase();
            filePath = filePath.substring(0, 1).toUpperCase();
        }else{
            int firstCommaIndex = directoryPath.indexOf("/");
            int secondCommaIndex = directoryPath.indexOf("/", firstCommaIndex + 1);
            directoryPath =directoryPath.substring(firstCommaIndex + 1, secondCommaIndex);

            int firstCommaIndex1 = filePath.indexOf("/");
            int secondCommaIndex1 = filePath.indexOf("/", firstCommaIndex1 + 1);
            filePath =filePath.substring(firstCommaIndex1 + 1, secondCommaIndex1);
        }

        //获取系统资源阈值配置项
        List<SysConfigEntity> sysConfigList = sysConfigService.getConfigListByCategory("ServiceAlertSysConfig");
        String cupSystem = "";
        String memorySystem = "";
        String diskSystem = "";
        //如果为设置，去系统默认值
        if(sysConfigList.size() < 1){
            cupSystem = CUP_SYSTEM;
            memorySystem = MEMORY_SYSTEM;
            diskSystem = DISK_SYSTEM;
        }
        for (SysConfigEntity sysConfigEntity:sysConfigList) {
            if("serviceCPU".equals(sysConfigEntity.getKeyName())){
                cupSystem = sysConfigEntity.getKeyValue();
            }else if("serviceMemory".equals(sysConfigEntity.getKeyName())){
                memorySystem = sysConfigEntity.getKeyValue();
            }else if("serviceDisk".equals(sysConfigEntity.getKeyName())){
                diskSystem = sysConfigEntity.getKeyValue();
            }
        }

        //记录服务告警信息
        StringBuilder stringBuilder = new StringBuilder();

        //获取服务器系统资源
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        FileSystem fileSystem = os.getFileSystem();
        List<OSFileStore> fsArray = fileSystem.getFileStores();
        //比较cpu使用率
        if(new BigDecimal(cupIdle).compareTo(new BigDecimal(cupSystem)) >= 0){
            stringBuilder.append("CPU使用率达到：" + cupIdle + "%；\r\n" );
        }
        //比较内存使用率
        if(new BigDecimal(memoryUsageRate).compareTo(new BigDecimal(memorySystem)) >= 0){
            stringBuilder.append("内存使用率达到：" + memoryUsageRate + "%；\r\n" );
        }
        //比较磁盘空间大小
        for (OSFileStore file : fsArray) {
            if (file.getMount().contains(directoryPath) && new BigDecimal((file.getUsableSpace() / 1024 / 1024 / 1024)).compareTo(new BigDecimal(diskSystem)) < 0) {
                stringBuilder.append("程序盘("+directoryPath+")可使用空间为：" + new BigDecimal((file.getUsableSpace() / 1024 / 1024 / 1024)) + "G；\r\n");
            }
            if (file.getMount().contains(filePath) && new BigDecimal((file.getUsableSpace() / 1024 / 1024 / 1024)).compareTo(new BigDecimal(diskSystem)) < 0) {
                stringBuilder.append("附件盘("+filePath+")可使用空间为：" + new BigDecimal((file.getUsableSpace() / 1024 / 1024 / 1024)) + "G；\r\n");
            }
        }
        //判断是否有告警信息以及信息接收人-满足条件开始发送消息
        //获取信息接收人
        SysConfigEntity sysConfigEntity = sysConfigService.getConfigByKeyName("ServiceAlertUsers");
        List<String> ids = JSONObject.parseArray(sysConfigEntity.getKeyValue(), String.class);
        if(StringUtils.isNotEmpty(stringBuilder.toString()) && ids.size() > 0){
            SysConfigEntity configEntity = sysConfigService.getConfigByKeyName("sysName");
            this.newSendMessage(ids, configEntity.getKeyValue()+"服务器资源预警", stringBuilder.toString(), "");
        }

    }
    /**
     * 发送信息-新
     *
     * @param userId
     * @param title
     * @param content
     * @param content
     * @throws DataException
     */
    private void newSendMessage(List<String> userId, String title, String content, String url) throws Exception {
        if (userId.size() > 0) {
            try {
                TaskMsg taskMsg = new TaskMsg();
                taskMsg.setTaskCode("服务器资源预警");
                taskMsg.setSendCode("ServiceAlertMessageTemplate");
                Map<String, String> map = new HashMap<>();
                map.put("title", title);
                map.put("content", content);
                BusinessKeys businessKeys = new BusinessKeys();
                businessKeys.setKeys(map);
                taskMsg.setBusinessKey(businessKeys);
                taskMsg.setToUserIds(StringUtils.join(userId,","));
                sendTaskMsgUtils.sendTaskMsg(taskMsg);
            } catch (Exception e) {
                LOG.error("发消息异常,{}",e.getMessage());
            }
        }



    }
    /**
     * 发送信息
     *
     * @param userId
     * @param title
     * @param content
     * @param content
     * @throws DataException
     */
    private void sendMessage(List<String> userId, String title, String content, String url) throws Exception {
        List<String> collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(40);
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId(sysConfigService.getConfigByKeyName("ServiceAlertMessage").getKeyValue());
        sentMessageForm.setTitle(title);
        sentMessageForm.setContent(content);
        sentMessageForm.setBodyText(new HashMap<>());
        Map<String, String> map = new HashMap<>();
        map.put("title", title);
        map.put("content", content);
        //标题
        // 关联产品
        //PC跳转路径
//        map.put("PcUrl", "http://gl.bringspring.com/jsbos-web/#/crm/crmcustomeropportunity?id=" + opportunityId;
        //移动端跳转路径
        map.put("AppUrl", sysConfigService.getSystemAddress("app") + url);
        sentMessageForm.setParameterMap(map);
        List<SentMessageForm> messageListAll = new ArrayList<>();
        messageListAll.add(sentMessageForm);
        for (SentMessageForm messageForm : messageListAll) {
            if (messageForm.getToUserIds().size() > 0) {
                try {
                    sentMessageUtil.sendMessage(messageForm);
                } catch (Exception e) {
                    LOG.error("发消息异常,{}",e.getMessage());
                }
            }
        }
    }
}
