package com.bringspring.system.external.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.treeutil.SumTree;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.model.dingding.DingDeptModel;
import com.bringspring.system.base.model.dingding.DingUserIdModel;
import com.bringspring.system.base.model.dingding.DingUserModel;
import com.bringspring.system.external.config.mutil.DingTalkConfiguration;
import com.bringspring.system.external.listener.DIngTalkStream;
import com.bringspring.system.external.util.DingTalkSynUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.OraganizeListVO;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.msgcenter.model.message.MyDingTalkModel;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiUserListidRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiUserListidResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import static com.bringspring.system.external.util.DingTalkSynUtil.*;
import static com.bringspring.system.message.util.SynThirdConsts.*;
import static com.bringspring.system.permission.constant.PermissionConst.SIMPLE_USER;

/**
 * 阿里钉钉通讯录信息同步的公司-部门-用户同步表模型
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/4/25 9:30
 */
@Slf4j
@Tag(name = "阿里钉钉通讯录信息同步")
@RestController
@RequestMapping("/api/external/dingTalk/{corpId}/{appId}")
public class DingTalkSynThirdController {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private SynThirdDingTalkService synThirdDingTalkService;
    @Autowired
    private DingTalkConfiguration dingTalkConfiguration;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;

    @Autowired
    private RoleService roleService;

    @Autowired
    private DIngTalkStream dIngTalkStream;

    //==================================本系统的公司-部门-用户批量同步到钉钉==================================

    /**
     * 本地所有组织信息(包含公司和部门)同步到钉钉
     * 不带第三方错误定位判断的功能代码 20210604
     *
     * @param corpId 企业唯一标识
     * @param appId  应用唯一标识
     * @return ignore
     */
    @Operation(summary="本地所有组织信息(包含公司和部门)同步到钉钉")
    @PostMapping("/synAllOrganizeSysToDing")
    public ActionResult synAllOrganizeSysToDing(@PathVariable("corpId") String corpId, @PathVariable("appId") String appId) {
        JSONObject retMsg = new JSONObject();
        MyDingTalkModel dingTalkModel = dingTalkConfiguration.getDingTalkModel(corpId);
        String appKey = dingTalkModel.getClientId();
        String appSecret = dingTalkModel.getClientSecrent();
        try {
            // 获取Token值
            JSONObject tokenObject = DingTalkSynUtil.getAccessToken(appKey, appSecret);
            if (!tokenObject.getBoolean("code")) {
                return ActionResult.fail("获取钉钉的access_token失败");
            }
            String access_token = tokenObject.getString("access_token");

            // 获取同步表、部门表的信息
            List<SynThirdInfoEntity> synThirdInfoList = synThirdInfoService.getList(SynThirdConsts.THIRD_TYPE_DING,
                    DATA_TYPE_ORG);
            List<OrganizeEntity> organizeList = organizeService.getList();

            // 部门进行树结构化,固化上下层级序列化
            List<OrganizeModel> organizeModelList = JsonUtil.getJsonToList(organizeList, OrganizeModel.class);
            List<SumTree<OrganizeModel>> trees = TreeDotUtils.convertListToTreeDot(organizeModelList);
            List<OraganizeListVO> listVO = JsonUtil.getJsonToList(trees, OraganizeListVO.class);

            // 转化成为按上下层级顺序排序的列表数据
            List<OrganizeEntity> listByOrder = new ArrayList<>();
            for (OraganizeListVO organizeVo : listVO) {
                OrganizeEntity entity =
                        organizeList.stream().filter(t -> t.getId().equals(organizeVo.getId())).findFirst().orElse(null);
                listByOrder.add(entity);
                DingTalkSynUtil.getOrganizeTreeToList(organizeVo, organizeList, listByOrder);
            }

            // 根据同步表、公司表进行比较，判断不存的执行删除
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (organizeList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() == 0 ? true : false) {
                    //执行删除操作
                    retMsg = synThirdDingTalkService.deleteDepartmentSysToDing(true,
                            synThirdInfoEntity.getSystemObjectId(), access_token);
                }
            }

            synThirdInfoList = synThirdInfoService.getList(SynThirdConsts.THIRD_TYPE_DING, DATA_TYPE_ORG);
            // 根据公司表、同步表进行比较，决定执行创建、还是更新
            for (OrganizeEntity organizeEntity : listByOrder) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(organizeEntity.getId())).count() > 0 ? true : false) {
                    // 执行更新功能
                    retMsg = synThirdDingTalkService.updateDepartmentSysToDing(true, organizeEntity, access_token);
                } else {
                    // 执行创建功能
                    retMsg = synThirdDingTalkService.createDepartmentSysToDing(true, organizeEntity, access_token);
                }
            }
        } catch (Exception e) {
            ActionResult.fail(e.toString());
        }

        //获取结果
        SynThirdTotal synThirdTotal = synThirdInfoService.getSynTotal(SynThirdConsts.THIRD_TYPE_DING, DATA_TYPE_ORG);
        return ActionResult.success(synThirdTotal);
    }


    /**
     * 本地所有用户信息同步到钉钉
     * 不带第三方错误定位判断的功能代码 20210604
     *
     * @return ignore
     */
    @Operation(summary="本地所有用户信息同步到钉钉")
    @PostMapping("/synAllUserSysToDing")
    public ActionResult synAllUserSysToDing(@PathVariable("corpId") String corpId, @PathVariable("appId") String appId) throws ParseException {
        JSONObject retMsg = new JSONObject();
        MyDingTalkModel dingTalkModel = dingTalkConfiguration.getDingTalkModel(corpId);
        String appKey = dingTalkModel.getClientId();
        String appSecret = dingTalkModel.getClientSecrent();

        try {
            // 获取Token值
            JSONObject tokenObject = DingTalkSynUtil.getAccessToken(appKey, appSecret);
            if (!tokenObject.getBoolean("code")) {
                return ActionResult.success("获取钉钉的access_token失败");
            }
            String access_token = tokenObject.getString("access_token");

            // 获取同步表、用户表的信息
            List<SynThirdInfoEntity> synThirdInfoList =
                    synThirdInfoService.getList(SynThirdConsts.THIRD_TYPE_DING, DATA_TYPE_USER);
            List<UserEntity> userList = userService.getList();

            // 根据同步表、公司表进行比较，判断不存的执行删除
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (userList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() == 0 ? true : false) {
                    // 执行删除操作
                    retMsg = synThirdDingTalkService.deleteUserSysToDing(true, synThirdInfoEntity.getSystemObjectId()
                            , access_token);
                }
            }

            // 根据公司表、同步表进行比较，决定执行创建、还是更新
            for (UserEntity userEntity : userList) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(userEntity.getId())).count() == 0 ? true : false) {
                    // 执行创建功能
                    retMsg = synThirdDingTalkService.createUserSysToDing(true, userEntity, access_token);
                } else {
                    // 执行更新功能
                    retMsg = synThirdDingTalkService.updateUserSysToDing(true, userEntity, access_token);
                }
            }
        } catch (Exception e) {
            ActionResult.fail(e.toString());
        }

        //获取结果
        SynThirdTotal synThirdTotal = synThirdInfoService.getSynTotal(SynThirdConsts.THIRD_TYPE_DING, DATA_TYPE_USER);
        return ActionResult.success(synThirdTotal);
    }

//    public static void main(String[] args) throws Exception {
//
//        OpenDingTalkStreamClientBuilder.custom().credential(new AuthClientCredential("dingqgbtl0pzm45qbonu",
//                "299RRMGBuD-Hsw9LE76DzJi-ApKmq3MABXm-tS8-plFFt189RrSJi_qB0U7tAot1"))
//                //注册事件监听
//                .registerAllEventListener(new GenericEventListener() {
//                    public EventAckStatus onEvent(GenericOpenDingTalkEvent event) {
//                        try {
//                            //事件唯一Id
//                            String eventId = event.getEventId();
//                            //事件类型
//                            String eventType = event.getEventType();
//                            //事件产生时间
//                            Long bornTime = event.getEventBornTime();
//                            //获取事件体
//                            JSONObject bizData = event.getData();
//                            //处理事件
////                            if ("org_dept_create".equals(eventType)||"org_dept_modify".equals(eventType)){
////                                orgChange(bizData);
////                            }
//                            process((List<Word>) bizData);
//                            //消费成功
//                            return EventAckStatus.SUCCESS;
//                        } catch (Exception e) {
//                            //消费失败
//                            return EventAckStatus.LATER;
//                        }
//                    }
//                }).build().start();
//    }

    /**
     * 钉钉所有组织信息(包含公司和部门)同步到本地
     * 不带第三方错误定位判断的功能代码 20210604
     *
     * @return ignore
     */
    @Operation(summary="钉钉所有组织信息(包含公司和部门)同步到本地")
    @PostMapping("/synDingToAllOrganizeSys")
    public ActionResult synDingToAllOrganizeSys(@PathVariable("corpId") String corpId, @PathVariable("appId") String appId) throws Exception {
        MyDingTalkModel dingTalkModel = dingTalkConfiguration.getDingTalkModel(corpId);
        String appKey = dingTalkModel.getClientId();
        String appSecret = dingTalkModel.getClientSecrent();
        // 获取Token值
        JSONObject tokenObject = DingTalkSynUtil.getAccessToken(appKey, appSecret);
        if (!tokenObject.getBoolean("code")) {
            return ActionResult.success("获取钉钉的access_token失败");
        }
        String access_token = tokenObject.getString("access_token");
        OapiGettokenRequest req = new OapiGettokenRequest();
        String serverUrl = TOPAPI + GET_DEPARTMENT_LIST;
        DingTalkClient client = new DefaultDingTalkClient(serverUrl);
        OapiGettokenResponse execute = client.execute(req, access_token);
        System.out.println(execute.getBody());
        List<DingDeptModel> resultDepart =
                JsonUtil.getJsonToList(String.valueOf(JsonUtil.stringToMap(execute.getBody()).get("result")),
                        DingDeptModel.class);
        if (CollectionUtil.isNotEmpty(resultDepart)) {
            // 有的新增，没有的编辑。
            return dIngTalkStream.orgAOD(resultDepart, corpId);
        } else {
            return ActionResult.fail("没有调用该接口的权限");
        }
    }

    /**
     * 钉钉所有用户同步到本地
     * 不带第三方错误定位判断的功能代码 20210604
     *
     * @return ignore
     */
    @Operation(summary="钉钉所有用户同步到本地")
    @PostMapping("/synDingToAllUserSys")
    public ActionResult synDingToAllUserSys(@PathVariable("corpId") String corpId, @PathVariable("appId") String appId) throws Exception {
        MyDingTalkModel dingTalkModel = dingTalkConfiguration.getDingTalkModel(corpId);
        String appKey = dingTalkModel.getClientId();
        String appSecret = dingTalkModel.getClientSecrent();
        // 获取Token值
        JSONObject tokenObject = DingTalkSynUtil.getAccessToken(appKey, appSecret);
        if (!tokenObject.getBoolean("code")) {
            return ActionResult.success("获取钉钉的access_token失败");
        }
        String accessToken = tokenObject.getString("access_token");
        OapiGettokenRequest req = new OapiGettokenRequest();
        // 获取部门列表
        DingTalkClient client = new DefaultDingTalkClient(TOPAPI + GET_DEPARTMENT_LIST);
        OapiGettokenResponse execute = client.execute(req, accessToken); // openapi调用
        System.out.println(execute.getBody());
        List<DingDeptModel> resultDepart = new ArrayList<>();
        DingDeptModel dingDeptModelPar = new DingDeptModel();
        dingDeptModelPar.setDept_id("1");
        resultDepart.add(dingDeptModelPar);
        Object result = JsonUtil.stringToMap(execute.getBody()).get("result");
        List<DingDeptModel> dingDeptList = JsonUtil.getJsonToList(String.valueOf(result), DingDeptModel.class);
        resultDepart.addAll(dingDeptList);
        List<DingUserModel> resultUserList = new ArrayList<>();
        List<RoleEntity> listByEnCode = roleService.getListByEnCode(SIMPLE_USER);
        List<SynThirdInfoEntity> listThird = synThirdInfoService.getList(THIRD_TYPE_DING, DATA_TYPE_USER);
        UserInfo userInfo = userProvider.get();
        // 获取部门下人员id
        if (!ObjectUtil.isEmpty(resultDepart)) {
            for (int i = 0; i < resultDepart.size(); i++) {
                DingDeptModel dingDeptModel = resultDepart.get(i);
                // 获取部门用户userid列表
                DingTalkClient clientUserId = new DefaultDingTalkClient(TOPAPI + GET_USER_LISTID);
                OapiUserListidRequest reqUserId = new OapiUserListidRequest();
                reqUserId.setDeptId(Long.valueOf(dingDeptModel.getDept_id())); // 部门deptId
                OapiUserListidResponse rspUserListid = clientUserId.execute(reqUserId, accessToken); // openapi调用
                System.out.println(rspUserListid.getBody());
                String resUserListid = String.valueOf(JsonUtil.stringToMap(rspUserListid.getBody()).get("result"));
                DingUserIdModel userListid = JsonUtil.getJsonToBean(resUserListid, DingUserIdModel.class);
                if (!ObjectUtil.isEmpty(userListid) && CollectionUtil.isNotEmpty(userListid.getUserid_list())) {
                    List<String> userid_list = userListid.getUserid_list();
                    for (String userid : userid_list) {
                        // 获取指定用户的详细信息
                        DingTalkClient clientUser = new DefaultDingTalkClient(TOPAPI + GET_SINGLE_USER);
                        OapiV2UserGetRequest reqUser = new OapiV2UserGetRequest();
                        reqUser.setUserid(userid); // 用户的userId
                        OapiV2UserGetResponse rspUser = clientUser.execute(reqUser, accessToken);  // openapi调用
                        String resUser = String.valueOf(JsonUtil.stringToMap(rspUser.getBody()).get("result"));
                        DingUserModel user = JsonUtil.getJsonToBean(resUser, DingUserModel.class);
                        user.setDepartmentId(dingDeptModel.getDept_id());
                        if (CollectionUtil.isNotEmpty(resultDepart)) {
                            dIngTalkStream.userAOD(user.getUserid(), corpId);
                            resultUserList.add(user);
                        } else {
                            return ActionResult.fail("没有调用该接口的权限");
                        }
                    }
                }
            }
        }

        //获取结果
        SynThirdTotal synThirdTotal = synThirdInfoService.getSynTotal(SynThirdConsts.THIRD_TYPE_DING, DATA_TYPE_ORG);
        return ActionResult.success(synThirdTotal);
    }

}
